/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.database;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.database.AbstractDatabase;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SQLiteDatabase
extends AbstractDatabase {
    private Connection conn = null;
    private long insertId = -1L;
    private boolean useReturningRowId;

    public SQLiteDatabase(File name) {
        try {
            this.conn = DriverManager.getConnection("jdbc:sqlite:" + name.getAbsolutePath());
            this.useReturningRowId = !this.conn.getMetaData().supportsGetGeneratedKeys();
        }
        catch (SQLException e) {
            SmileyPlayerTrader.getInstance().getLogger().severe("Failed to open/create SQLite3 database. Disabling...");
            Bukkit.getPluginManager().disablePlugin((Plugin)SmileyPlayerTrader.getInstance());
            e.printStackTrace();
        }
    }

    private void setValues(PreparedStatement stmt, Object ... objs) {
        for (int i = 0; i < objs.length; ++i) {
            try {
                stmt.setObject(i + 1, objs[i]);
                continue;
            }
            catch (SQLException e) {
                SmileyPlayerTrader.getInstance().getLogger().severe("Failed to set a value in an SQLite3 statement.");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run(String sql, Object ... objs) {
        this.logSQLStatement("run", sql, objs);
        try {
            if (!this.isConnected()) {
                SmileyPlayerTrader.getInstance().getLogger().severe("Failed to run statement as there is no database connection.");
                return;
            }
            PreparedStatement stmt = this.useReturningRowId ? this.conn.prepareStatement(sql) : this.conn.prepareStatement(sql, 1);
            this.setValues(stmt, objs);
            stmt.execute();
            if (this.useReturningRowId) {
                ResultSet s = stmt.getResultSet();
                if (s != null && s.next()) {
                    this.insertId = s.getLong(1);
                }
            } else {
                ResultSet s = stmt.getGeneratedKeys();
                if (s.next()) {
                    this.insertId = s.getLong(1);
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            SmileyPlayerTrader.getInstance().getLogger().severe("Failed to execute SQLite3 statement.");
            e.printStackTrace();
        }
    }

    @Override
    public long runAndReturnInsertId(String sql, Object ... objs) {
        if (this.useReturningRowId) {
            this.run(sql + " RETURNING rowid", objs);
        } else {
            this.run(sql, objs);
        }
        return this.insertId;
    }

    @Override
    public ResultSet get(String sql, Object ... objs) {
        this.logSQLStatement("get", sql, objs);
        try {
            if (!this.isConnected()) {
                SmileyPlayerTrader.getInstance().getLogger().severe("Failed to run statement as there is no database connection.");
                return null;
            }
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            this.setValues(stmt, objs);
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            SmileyPlayerTrader.getInstance().getLogger().severe("Failed to execute SQLite3 query statement.");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isConnected() {
        try {
            return this.conn != null && !this.conn.isClosed();
        }
        catch (SQLException e) {
            SmileyPlayerTrader.getInstance().getLogger().warning("Failed to check connection status, assuming not connected!");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        if (!this.isConnected()) {
            SmileyPlayerTrader.getInstance().getLogger().severe("Failed to close connection as not connected!");
            return;
        }
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            SmileyPlayerTrader.getInstance().getLogger().severe("Failed to close connection.");
            e.printStackTrace();
        }
    }

    @Override
    protected void upgrade(int version) {
        if (version == 1) {
            this.run("ALTER TABLE products RENAME TO " + this.getDatabasePrefix() + "products", new Object[0]);
        } else if (version == 2) {
            this.run("CREATE TABLE IF NOT EXISTS " + this.getDatabasePrefix() + "settings (player TEXT NOT NULL,trade_toggle BOOLEAN DEFAULT 1 NOT NULL,combat_notice_toggle BOOLEAN DEFAULT 1 NOT NULL)", new Object[0]);
        } else if (version == 3) {
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN available BOOLEAN DEFAULT 1 NOT NULL", new Object[0]);
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN special_price INTEGER DEFAULT 0 NOT NULL", new Object[0]);
        } else if (version == 4) {
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN priority INTEGER DEFAULT 0 NOT NULL", new Object[0]);
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN stored_product INTEGER DEFAULT 0 NOT NULL", new Object[0]);
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN stored_cost INTEGER DEFAULT 0 NOT NULL", new Object[0]);
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN stored_cost2 INTEGER DEFAULT 0 NOT NULL", new Object[0]);
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN hide_on_out_of_stock INTEGER DEFAULT 0 NOT NULL", new Object[0]);
        } else if (version == 5) {
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN purchase_limit INTEGER DEFAULT -1 NOT NULL", new Object[0]);
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN purchase_count INTEGER DEFAULT 0 NOT NULL", new Object[0]);
        } else if (version == 6) {
            this.run("ALTER TABLE " + this.getDatabasePrefix() + "products ADD COLUMN unlimited_supply BOOLEAN DEFAULT 0 NOT NULL", new Object[0]);
        }
    }
}

