/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.item;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.impl.itemintegration.IItemIntegrationImpl;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemIntegration;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.IStockLocation;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.StockLocations;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUtil {
    public static int computeAdjustedPrice(MerchantRecipe recipe, int specialPrice) {
        return ((ItemStack)recipe.getIngredients().get(0)).getAmount() + specialPrice;
    }

    public static void giveEarnings(OfflinePlayer player, MerchantRecipe recipe, int specialPrice, long productId) {
        ItemStack first = ((ItemStack)recipe.getIngredients().get(0)).clone();
        first.setAmount(first.getAmount() + specialPrice);
        ItemStack second = recipe.getIngredients().size() >= 2 ? ((ItemStack)recipe.getIngredients().get(1)).clone() : null;
        List<IStockLocation> stockLocations = StockLocations.getActiveStockLocations();
        for (IStockLocation location : stockLocations) {
            if (location.isAvailable(player)) {
                if (first != null) {
                    first = location.giveEarnings(player, first, productId, true);
                }
                if (second != null) {
                    second = location.giveEarnings(player, second, productId, false);
                }
            }
            if (first != null || second != null) continue;
            return;
        }
        if (player.isOnline()) {
            Player p = player.getPlayer();
            assert (p != null);
            if (first != null) {
                p.getWorld().dropItem(p.getLocation(), first);
            }
            if (second != null) {
                p.getWorld().dropItem(p.getLocation(), second);
            }
        }
    }

    public static void removeStock(OfflinePlayer player, ItemStack item, long productId) {
        item = item.clone();
        List<IStockLocation> stockLocations = StockLocations.getActiveStockLocations();
        for (IStockLocation location : stockLocations) {
            int count;
            if (!location.isAvailable(player) || SmileyPlayerTrader.getInstance().getConfiguration().isUseOnlyOneStockLocation() && (count = location.doesPlayerHaveItem(player, item, productId)) < item.getAmount() || (item = location.removeStock(player, item, productId)) != null) continue;
            return;
        }
    }

    public static boolean doesPlayerHaveItem(OfflinePlayer player, ItemStack item, long productId) {
        int found = 0;
        List<IStockLocation> stockLocations = StockLocations.getActiveStockLocations();
        for (IStockLocation location : stockLocations) {
            if (!location.isAvailable(player)) continue;
            if ((found += location.doesPlayerHaveItem(player, item, productId)) >= item.getAmount()) {
                return true;
            }
            if (!SmileyPlayerTrader.getInstance().getConfiguration().isUseOnlyOneStockLocation() || found >= item.getAmount()) continue;
            found = 0;
        }
        return false;
    }

    public static ItemStack buildConfigurationItem(LinkedHashMap<String, Object> item) {
        Material mat;
        if (!item.containsKey("type") || !(item.get("type") instanceof String)) {
            SmileyPlayerTrader.getInstance().getLogger().severe("type is not String");
            return null;
        }
        if (!item.containsKey("is") || !(item.get("is") instanceof String) || ((String)item.get("is")).equalsIgnoreCase("vanilla")) {
            mat = Material.getMaterial((String)((String)item.get("type")));
            if (mat == null) {
                if (SmileyPlayerTrader.getInstance().getDescription().getVersion().contains("SNAPSHOT")) {
                    SmileyPlayerTrader.getInstance().getLogger().warning(item.get("type") + " does not exist (is it spelled right or from a version this server doesn't support?)");
                }
                return null;
            }
            if (!mat.isItem() || mat.isAir()) {
                SmileyPlayerTrader.getInstance().getLogger().severe("Material is not an item/block or is air.");
                return null;
            }
        } else {
            String itemIs = (String)item.get("is");
            if (ItemIntegration.hasItemIntegration(itemIs)) {
                IItemIntegrationImpl impl = ItemIntegration.getItemIntegration(itemIs);
                if (impl == null) {
                    SmileyPlayerTrader.getInstance().getLogger().severe(itemIs + " is not available (is the plugin installed?)");
                    return null;
                }
                return impl.getItem(item);
            }
            SmileyPlayerTrader.getInstance().getLogger().severe("Bad item type.");
            return null;
        }
        ItemStack is = new ItemStack(mat);
        if (item.containsKey("meta")) {
            Object obj = item.get("meta");
            if (!(obj instanceof ItemMeta)) {
                SmileyPlayerTrader.getInstance().getLogger().severe("meta is not ItemMeta");
                return null;
            }
            ItemMeta im = (ItemMeta)obj;
            if (im.hasDisplayName()) {
                im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)im.getDisplayName()));
            }
            if (im.hasLore()) {
                List lore = im.getLore();
                for (int i = 0; i < lore.size(); ++i) {
                    lore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)lore.get(i))));
                }
                im.setLore(lore);
            }
            is.setItemMeta(im);
        }
        if (item.containsKey("amount")) {
            Object amountObj = item.get("amount");
            if (!(amountObj instanceof Integer)) {
                SmileyPlayerTrader.getInstance().getLogger().severe("amount is not Integer");
                return null;
            }
            is.setAmount(((Integer)amountObj).intValue());
        }
        return is;
    }

    public static boolean isHiddenItem(List<String> hiddenItems, Material m) {
        if (hiddenItems.contains(m.name())) {
            return true;
        }
        return hiddenItems.contains("%SPAWN_EGGS%") && m.name().endsWith("_SPAWN_EGG");
    }

    public static boolean collectEarnings(Player p) {
        boolean bl;
        block13: {
            int collected = 0;
            ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.FIND_PRODUCTS_WITH_EARNINGS, p.getUniqueId().toString());
            try {
                while (set.next()) {
                    ItemStack cost = VersionSupport.byteArrayToItemStack(set.getBytes("cost1"));
                    byte[] cost2Bytes = set.getBytes("cost2");
                    ItemStack cost2 = cost2Bytes == null ? null : VersionSupport.byteArrayToItemStack(cost2Bytes);
                    int amount = set.getInt("stored_cost");
                    int amount2 = set.getInt("stored_cost2");
                    if (amount > 0 || amount2 > 0) {
                        ++collected;
                    }
                    cost.setAmount(amount);
                    HashMap errs = p.getInventory().addItem(new ItemStack[]{cost});
                    for (ItemStack is : errs.values()) {
                        p.getWorld().dropItem(p.getLocation(), is);
                    }
                    if (cost2 != null) {
                        cost2.setAmount(amount2);
                        errs = p.getInventory().addItem(new ItemStack[]{cost2});
                        for (ItemStack is : errs.values()) {
                            p.getWorld().dropItem(p.getLocation(), is);
                        }
                    }
                    SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.SET_STORED_COST, 0, set.getLong("id"));
                    SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.SET_STORED_COST2, 0, set.getLong("id"));
                }
                boolean bl2 = bl = collected > 0;
                if (set == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvocationTargetException | SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            set.close();
        }
        return bl;
    }

    public static BaseComponent getItemTextComponent(ItemStack stack) {
        TextComponent itemName;
        ItemMeta itemMeta = stack.getItemMeta();
        if (itemMeta == null) {
            return new TextComponent(stack.getType().toString());
        }
        String preferredItemName = VersionSupport.getPreferredItemName(itemMeta);
        if (preferredItemName != null) {
            itemName = new TextComponent(preferredItemName);
        } else {
            NamespacedKey key = stack.getType().getKey();
            itemName = new TranslatableComponent((stack.getType().isBlock() ? "block." : "item.") + key.getNamespace() + "." + key.getKey(), new Object[0]);
        }
        return itemName;
    }
}

