/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations;

import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.IStockLocation;
import java.util.HashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryStockLocation
implements IStockLocation {
    private Inventory getInventory(OfflinePlayer player) {
        if (!player.isOnline()) {
            throw new IllegalStateException("Player is not online.");
        }
        return player.getPlayer().getInventory();
    }

    @Override
    public ItemStack giveEarnings(OfflinePlayer player, ItemStack stack, long id, boolean primaryCost) {
        Inventory inventory = this.getInventory(player);
        HashMap errs = inventory.addItem(new ItemStack[]{stack});
        if (errs.isEmpty()) {
            return null;
        }
        int count = 0;
        for (ItemStack is : errs.values()) {
            count += is.getAmount();
        }
        ItemStack out = stack.clone();
        out.setAmount(count);
        return out;
    }

    @Override
    public ItemStack removeStock(OfflinePlayer player, ItemStack stack, long id) {
        Inventory inventory = this.getInventory(player);
        int needed = stack.getAmount();
        for (ItemStack is : inventory.getStorageContents()) {
            if (is == null || !is.isSimilar(stack)) continue;
            if (is.getAmount() >= needed) {
                is.setAmount(is.getAmount() - needed);
                return null;
            }
            needed -= is.getAmount();
            is.setAmount(0);
        }
        if (needed > 0) {
            ItemStack out = stack.clone();
            out.setAmount(needed);
            return out;
        }
        return null;
    }

    @Override
    public int doesPlayerHaveItem(OfflinePlayer player, ItemStack stack, long id) {
        Inventory inventory = this.getInventory(player);
        int found = 0;
        for (ItemStack is : inventory.getStorageContents()) {
            if (is == null || !is.isSimilar(stack) || (found += is.getAmount()) < stack.getAmount()) continue;
            return found;
        }
        return found;
    }

    @Override
    public boolean isAvailable(OfflinePlayer player) {
        return player.isOnline();
    }
}

