/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.IStockLocation;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;

public class ItemStorageStockLocation
implements IStockLocation {
    @Override
    public ItemStack giveEarnings(OfflinePlayer player, ItemStack stack, long id, boolean primaryCost) {
        if (primaryCost) {
            SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.CHANGE_STORED_COST, stack.getAmount(), id);
        } else {
            SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.CHANGE_STORED_COST2, stack.getAmount(), id);
        }
        return null;
    }

    @Override
    public ItemStack removeStock(OfflinePlayer player, ItemStack stack, long id) {
        int amount = this.doesPlayerHaveItem(player, stack, id);
        SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.CHANGE_STORED_PRODUCT, -amount, id);
        int remainingNeeded = stack.getAmount() - amount;
        if (remainingNeeded <= 0) {
            return null;
        }
        stack = stack.clone();
        stack.setAmount(remainingNeeded);
        return stack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int doesPlayerHaveItem(OfflinePlayer player, ItemStack stack, long id) {
        try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, id);){
            if (set.next()) {
                int n2 = set.getInt("stored_product");
                return n2;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isAvailable(OfflinePlayer player) {
        return SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageEnabled();
    }
}

