/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.IStockLocation;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ShulkerBoxStockLocation
implements IStockLocation {
    private boolean enderChest;

    public ShulkerBoxStockLocation(boolean enderChest) {
        this.enderChest = enderChest;
    }

    private Inventory getInventory(OfflinePlayer player) {
        assert (player.getPlayer() != null);
        return this.enderChest ? player.getPlayer().getEnderChest() : player.getPlayer().getInventory();
    }

    @Override
    public ItemStack giveEarnings(OfflinePlayer player, ItemStack stack, long id, boolean primaryCost) {
        return stack;
    }

    @Override
    public ItemStack removeStock(OfflinePlayer player, ItemStack stack, long id) {
        Inventory inventory = this.getInventory(player);
        int needed = stack.getAmount();
        for (ItemStack is : inventory.getStorageContents()) {
            BlockStateMeta blockStateMeta;
            BlockState blockState;
            ItemMeta im;
            if (is == null || is.getType() != Material.SHULKER_BOX || !((im = is.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (blockStateMeta = (BlockStateMeta)im).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            Inventory shulkerInventory = shulkerBox.getInventory();
            for (ItemStack item : shulkerInventory.getStorageContents()) {
                if (item == null || !item.isSimilar(stack)) continue;
                if (item.getAmount() >= needed) {
                    item.setAmount(item.getAmount() - needed);
                    shulkerBox.update();
                    blockStateMeta.setBlockState((BlockState)shulkerBox);
                    is.setItemMeta((ItemMeta)blockStateMeta);
                    return null;
                }
                needed -= item.getAmount();
                item.setAmount(0);
            }
            boolean storeInventory = true;
            if (SmileyPlayerTrader.getInstance().getConfiguration().isUseOnlyOneStockLocation() && needed > 0) {
                needed = stack.getAmount();
                storeInventory = false;
            }
            if (!storeInventory) continue;
            shulkerBox.update();
            blockStateMeta.setBlockState((BlockState)shulkerBox);
            is.setItemMeta((ItemMeta)blockStateMeta);
        }
        if (needed > 0) {
            ItemStack out = stack.clone();
            out.setAmount(needed);
            return out;
        }
        return null;
    }

    @Override
    public int doesPlayerHaveItem(OfflinePlayer player, ItemStack stack, long id) {
        Inventory inventory = this.getInventory(player);
        int found = 0;
        for (ItemStack is : inventory.getStorageContents()) {
            BlockStateMeta blockStateMeta;
            BlockState blockState;
            ItemMeta im;
            if (is == null || is.getType() != Material.SHULKER_BOX || !((im = is.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (blockStateMeta = (BlockStateMeta)im).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            Inventory shulkerInventory = shulkerBox.getInventory();
            for (ItemStack item : shulkerInventory.getStorageContents()) {
                if (item == null || !item.isSimilar(stack) || (found += item.getAmount()) < stack.getAmount()) continue;
                return found;
            }
            if (!SmileyPlayerTrader.getInstance().getConfiguration().isUseOnlyOneStockLocation()) continue;
            found = 0;
        }
        return found;
    }

    @Override
    public boolean isAvailable(OfflinePlayer player) {
        return player.isOnline();
    }
}

