/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader;

import io.github.mrcomputer1.smileyplayertrader.BugWarner;
import io.github.mrcomputer1.smileyplayertrader.EventListener;
import io.github.mrcomputer1.smileyplayertrader.PlayerConfig;
import io.github.mrcomputer1.smileyplayertrader.SPTConfiguration;
import io.github.mrcomputer1.smileyplayertrader.TradeEventListener;
import io.github.mrcomputer1.smileyplayertrader.UpdateChecker;
import io.github.mrcomputer1.smileyplayertrader.command.CommandSmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUIManager;
import io.github.mrcomputer1.smileyplayertrader.shades.org.bstats.bukkit.Metrics;
import io.github.mrcomputer1.smileyplayertrader.shades.org.bstats.charts.SimplePie;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.RegionUtil;
import io.github.mrcomputer1.smileyplayertrader.util.SPTPlaceholderExpansions;
import io.github.mrcomputer1.smileyplayertrader.util.database.AbstractDatabase;
import io.github.mrcomputer1.smileyplayertrader.util.database.DatabaseUtil;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.io.File;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SmileyPlayerTrader
extends JavaPlugin {
    private static final int BSTATS_PLUGIN_ID = 6187;
    private AbstractDatabase db;
    private StatementHandler statementHandler;
    private PlayerConfig playerConfig;
    private I18N i18n;
    private UpdateChecker updateChecker = null;
    private BugWarner bugWarner = null;
    private VersionSupport versionSupport = null;
    private SPTConfiguration configuration = null;
    private GUIManager guiManager = null;
    private Metrics metrics = null;

    public static SmileyPlayerTrader getInstance() {
        return (SmileyPlayerTrader)SmileyPlayerTrader.getPlugin(SmileyPlayerTrader.class);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.configuration = new SPTConfiguration((Configuration)this.getConfig());
        if (this.configuration.hasLegacyDisabledWorldsAndAllowedWorldsConfig()) {
            this.getLogger().warning("The configuration file specifies both the legacy 'disabledWorlds' configuration setting and the newer 'allowedWorlds' setting. The 'allowedWorlds.worlds' list will be prioritised over the legacy 'disabledWorlds' setting.");
        }
        if (!this.getDescription().getVersion().contains("-SNAPSHOT")) {
            this.metrics = new Metrics((Plugin)this, 6187);
            this.metrics.addCustomChart(new SimplePie("database_system", new Callable<String>(){

                @Override
                public String call() {
                    switch (SmileyPlayerTrader.this.getConfiguration().getDatabaseType()) {
                        case "sqlite": {
                            return "SQLite";
                        }
                        case "mysql": {
                            return "MySQL";
                        }
                    }
                    return "Unknown";
                }
            }));
        }
        this.i18n = new I18N();
        this.i18n.createLanguages();
        this.i18n.loadLanguages();
        this.i18n.updateLanguage();
        if (this.getConfiguration().getCheckForUpdatesEnabled()) {
            this.updateChecker = new UpdateChecker();
            this.updateChecker.checkForUpdates();
        }
        if (this.getConfiguration().getCheckForBugsEnabled()) {
            this.bugWarner = new BugWarner();
            boolean b = this.bugWarner.checkForBugs();
            if (b) {
                return;
            }
        }
        this.versionSupport = new VersionSupport();
        try {
            this.versionSupport.bindCompatibleVersion();
        }
        catch (IllegalStateException ex) {
            SmileyPlayerTrader.getInstance().getLogger().severe("MINECRAFT VERSION IS NOT SUPPORTED! DISABLING!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        boolean shouldCreateTables = true;
        if (this.getConfiguration().getDatabaseType().equals("sqlite") && new File(this.getDataFolder(), this.getConfiguration().getDatabaseFile()).exists()) {
            shouldCreateTables = false;
        }
        this.db = DatabaseUtil.loadDatabase();
        this.statementHandler = this.db.getNewStatementHandler();
        if (shouldCreateTables) {
            this.statementHandler.run(StatementHandler.StatementType.CREATE_PRODUCT_TABLE, new Object[0]);
            this.statementHandler.run(StatementHandler.StatementType.CREATE_META_TABLE, new Object[0]);
            this.statementHandler.run(StatementHandler.StatementType.CREATE_SETTINGS_TABLE, new Object[0]);
        }
        this.db.upgrade();
        this.playerConfig = new PlayerConfig();
        if (Bukkit.getOnlinePlayers().size() != 0) {
            this.playerConfig.reloadPlayers();
        }
        CommandSmileyPlayerTrader cspt = new CommandSmileyPlayerTrader();
        this.getCommand("smileyplayertrader").setExecutor((CommandExecutor)cspt);
        this.getCommand("smileyplayertrader").setTabCompleter((TabCompleter)cspt);
        Bukkit.getPluginManager().registerEvents((Listener)new EventListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new TradeEventListener(), (Plugin)this);
        if (this.getConfiguration().getUseGuiManager()) {
            this.guiManager = new GUIManager();
            Bukkit.getPluginManager().registerEvents((Listener)this.guiManager, (Plugin)this);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new SPTPlaceholderExpansions().register();
        }
    }

    public void onLoad() {
        RegionUtil.setup();
    }

    public void onDisable() {
        if (this.db != null) {
            this.db.close();
        }
    }

    public AbstractDatabase getDatabase() {
        return this.db;
    }

    public StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    public I18N getI18N() {
        return this.i18n;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public BugWarner getBugWarner() {
        return this.bugWarner;
    }

    public VersionSupport getVersionSupport() {
        return this.versionSupport;
    }

    public PlayerConfig getPlayerConfig() {
        return this.playerConfig;
    }

    public SPTConfiguration getConfiguration() {
        return this.configuration;
    }

    public GUIManager getGuiManager() {
        return this.guiManager;
    }
}

