/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.command;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.command.ICommand;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import io.github.mrcomputer1.smileyplayertrader.util.merchant.MerchantUtil;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ListCommand
implements ICommand {
    @Override
    public void onCommand(CommandSender sender, String[] args) {
        OfflinePlayer target;
        if (args.length != 0) {
            target = Bukkit.getOfflinePlayer((String)args[0]);
            if (!sender.hasPermission("smileyplayertrader.others")) {
                sender.sendMessage(I18N.translate("&cWhoops! You are not authorized to edit others products!", new Object[0]));
                return;
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(I18N.translate("&cYou must be running this command from a player.", new Object[0]));
                return;
            }
            target = (Player)sender;
        }
        try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.FIND_PRODUCTS, target.getUniqueId().toString());){
            while (set.next()) {
                boolean isStocked = true;
                byte[] productb = set.getBytes("product");
                String products = I18N.translate(", Product: UNSET", new Object[0]);
                if (productb != null) {
                    String preferredItemName;
                    ItemStack product = MerchantUtil.buildItem(productb);
                    if (target.isOnline() && !ItemUtil.doesPlayerHaveItem((OfflinePlayer)target.getPlayer(), product, set.getLong("id"))) {
                        isStocked = false;
                    }
                    products = (preferredItemName = VersionSupport.getPreferredItemName(product.getItemMeta())) != null ? I18N.translate(", Product: %0%x %1%", product.getAmount(), preferredItemName) : I18N.translate(", Product: %0%x %1%", product.getAmount(), product.getType());
                }
                byte[] cost1b = set.getBytes("cost1");
                String cost1s = I18N.translate(", Cost 1: UNSET", new Object[0]);
                if (cost1b != null) {
                    ItemStack cost1 = MerchantUtil.buildItem(cost1b);
                    String preferredItemName = VersionSupport.getPreferredItemName(cost1.getItemMeta());
                    cost1s = preferredItemName != null ? I18N.translate(", Cost 1: %0%x %1%", cost1.getAmount(), preferredItemName) : I18N.translate(", Cost 1: %0%x %1%", cost1.getAmount(), cost1.getType());
                }
                byte[] cost2b = set.getBytes("cost2");
                String cost2s = I18N.translate(", Cost 2: UNSET", new Object[0]);
                if (cost2b != null) {
                    ItemStack cost2 = MerchantUtil.buildItem(cost2b);
                    String preferredItemName = VersionSupport.getPreferredItemName(cost2.getItemMeta());
                    cost2s = preferredItemName != null ? I18N.translate(", Cost 2: %0%x %1%", cost2.getAmount(), preferredItemName) : I18N.translate(", Cost 2: %0%x %1%", cost2.getAmount(), cost2.getType());
                }
                String enabled = set.getBoolean("enabled") ? I18N.translate(", Enabled: YES", new Object[0]) : I18N.translate(", Enabled: NO", new Object[0]);
                String available = set.getBoolean("available") ? I18N.translate(", Available: YES", new Object[0]) : I18N.translate(", Available: NO", new Object[0]);
                if (set.getBoolean("enabled") && set.getBoolean("available")) {
                    if (isStocked) {
                        sender.sendMessage(I18N.translate("&e - %0% %1% %2% %3% %4% %5%", set.getLong("id"), products, cost1s, cost2s, enabled, available));
                        continue;
                    }
                    sender.sendMessage(I18N.translate("&c - [OUT OF STOCK] %0% %1% %2% %3% %4% %5%", set.getLong("id"), products, cost1s, cost2s, enabled, available));
                    continue;
                }
                sender.sendMessage(I18N.translate("&4 - %0% %1% %2% %3% %4% %5%", set.getLong("id"), products, cost1s, cost2s, enabled, available));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

