/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.command;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.command.ICommand;
import io.github.mrcomputer1.smileyplayertrader.util.CommandUtil;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import org.bukkit.command.CommandSender;

public class PurchaseLimitCommand
implements ICommand {
    @Override
    public void onCommand(CommandSender sender, String[] args) {
        int limit;
        long id;
        if (args.length < 1) {
            sender.sendMessage(I18N.translate("&cBad Syntax! &f/spt purchaselimit <id> [limit]", new Object[0]));
            return;
        }
        try {
            id = Long.parseLong(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
            return;
        }
        if (args.length < 2) {
            limit = -1;
        } else {
            try {
                limit = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                return;
            }
        }
        if (CommandUtil.isNotAuthorized(sender, id)) {
            sender.sendMessage(I18N.translate("&cWhoops! You are not authorized to edit others products!", new Object[0]));
            return;
        }
        if (limit < -1) {
            sender.sendMessage(I18N.translate("&cYou cannot have a negative purchase limit.", new Object[0]));
            return;
        }
        SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.SET_PURCHASE_LIMIT, id, limit);
        sender.sendMessage(I18N.translate("&aSet purchase limit.", new Object[0]));
    }
}

