/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.gui.productmanage;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.gui.GUIProductList;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUI;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUIManager;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.component.ButtonComponent;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.component.LabelComponent;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.inventory.ClickType;

public class GUIEnableDisableProduct
extends GUI {
    private final int id;
    private final boolean enable;
    private final int page;
    private final OfflinePlayer target;
    private final boolean isMine;

    public GUIEnableDisableProduct(int id, boolean enable, int page, OfflinePlayer target, boolean isMine) {
        super(enable ? I18N.translate("&2Enable/Show Product %0%", id) : I18N.translate("&2Disable/Hide Product %0%", id), 6);
        this.id = id;
        this.enable = enable;
        this.page = page;
        this.target = target;
        this.isMine = isMine;
        if (this.enable) {
            this.addChild(new LabelComponent(4, 2, Material.RED_STAINED_GLASS_PANE, 1, I18N.translate("&cEnabling/showing product will make it purchasable!", new Object[0]), new String[0]));
        } else {
            this.addChild(new LabelComponent(4, 2, Material.RED_STAINED_GLASS_PANE, 1, I18N.translate("&cDisabling/hiding product will make it no longer purchasable!", new Object[0]), new String[0]));
        }
        if (this.enable) {
            ButtonComponent enableBtn = new ButtonComponent(3, 4, Material.EMERALD_BLOCK, 1, I18N.translate("&aEnable/Show Product", new Object[0]), new String[0]);
            enableBtn.setOnClickEvent(this::onEnableClick);
            this.addChild(enableBtn);
            ButtonComponent dontEnableBtn = new ButtonComponent(5, 4, Material.REDSTONE_BLOCK, 1, I18N.translate("&cDon't Enable/Show Product", new Object[0]), new String[0]);
            dontEnableBtn.setOnClickEvent(this::onCancelClick);
            this.addChild(dontEnableBtn);
        } else {
            ButtonComponent hideBtn = new ButtonComponent(2, 4, Material.EMERALD_BLOCK, 1, I18N.translate("&aHide Product", new Object[0]), new String[0]);
            hideBtn.setOnClickEvent(this::onHideClick);
            this.addChild(hideBtn);
            ButtonComponent disableBtn = new ButtonComponent(4, 4, Material.GOLD_BLOCK, 1, I18N.translate("&aDisable Product", new Object[0]), new String[0]);
            disableBtn.setOnClickEvent(this::onDisableClick);
            this.addChild(disableBtn);
            ButtonComponent dontDisableHideBtn = new ButtonComponent(6, 4, Material.REDSTONE_BLOCK, 1, I18N.translate("&cDon't Disable/Hide Product", new Object[0]), new String[0]);
            dontDisableHideBtn.setOnClickEvent(this::onCancelClick);
            this.addChild(dontDisableHideBtn);
        }
    }

    private boolean onDisableClick(ClickType clickType) {
        SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.DISABLE_PRODUCT, this.id);
        GUIManager.getInstance().openGui(this.getPlayer(), new GUIProductList(this.getPlayer(), this.target, this.page, this.isMine));
        return false;
    }

    private boolean onHideClick(ClickType clickType) {
        SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.HIDE_PRODUCT, this.id);
        GUIManager.getInstance().openGui(this.getPlayer(), new GUIProductList(this.getPlayer(), this.target, this.page, this.isMine));
        return false;
    }

    private boolean onCancelClick(ClickType clickType) {
        GUIManager.getInstance().openGui(this.getPlayer(), new GUIProductList(this.getPlayer(), this.target, this.page, this.isMine));
        return false;
    }

    private boolean onEnableClick(ClickType clickType) {
        SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.ENABLE_PRODUCT, this.id);
        GUIManager.getInstance().openGui(this.getPlayer(), new GUIProductList(this.getPlayer(), this.target, this.page, this.isMine));
        return false;
    }
}

