/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;

public class I18N {
    private JsonObject language;
    private static String[] languages = new String[]{"en_us", "ru_ru", "pl_pl", "vi_vn"};

    public void loadLanguages() {
        String lang = SmileyPlayerTrader.getInstance().getConfiguration().getCurrentLanguage();
        File langFolder = new File(SmileyPlayerTrader.getInstance().getDataFolder(), "languages");
        JsonParser parser = new JsonParser();
        try {
            InputStreamReader isr = new InputStreamReader(new FileInputStream(new File(langFolder, lang + ".json")));
            this.language = parser.parse((Reader)isr).getAsJsonObject();
        }
        catch (JsonParseException | FileNotFoundException e) {
            SmileyPlayerTrader.getInstance().getLogger().warning("Invalid language. Loading en_us...");
            try {
                InputStreamReader isr = new InputStreamReader(new FileInputStream(new File(langFolder, lang + ".json")));
                this.language = parser.parse((Reader)isr).getAsJsonObject();
            }
            catch (JsonParseException | FileNotFoundException ex) {
                SmileyPlayerTrader.getInstance().getLogger().warning("Failed to load default en_us. Resetting language...");
                SmileyPlayerTrader.getInstance().saveResource("languages/en_us.json", true);
                try {
                    InputStreamReader isr = new InputStreamReader(new FileInputStream(new File(langFolder, lang + ".json")));
                    this.language = parser.parse((Reader)isr).getAsJsonObject();
                }
                catch (JsonParseException | FileNotFoundException exc) {
                    exc.printStackTrace();
                    SmileyPlayerTrader.getInstance().getLogger().severe("Failed to load language!");
                }
            }
        }
    }

    public void updateLanguage() {
        try {
            String lang = SmileyPlayerTrader.getInstance().getConfiguration().getCurrentLanguage();
            InputStream resource = SmileyPlayerTrader.getInstance().getResource("languages/" + lang + ".json");
            if (resource == null) {
                return;
            }
            JsonObject obj = new JsonParser().parse((Reader)new InputStreamReader(resource)).getAsJsonObject();
            if (obj.get("$$version$$").getAsInt() != this.language.get("$$version$$").getAsInt()) {
                SmileyPlayerTrader.getInstance().saveResource("languages/" + lang + ".json", true);
                this.loadLanguages();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void createLanguages() {
        File langFolder = new File(SmileyPlayerTrader.getInstance().getDataFolder(), "languages");
        if (!langFolder.exists() && !langFolder.mkdirs()) {
            SmileyPlayerTrader.getInstance().getLogger().severe("Failed to create languages directory.");
        }
        for (String lang : languages) {
            File file = new File(SmileyPlayerTrader.getInstance().getDataFolder(), "languages/" + lang + ".json");
            if (file.exists()) continue;
            SmileyPlayerTrader.getInstance().saveResource("languages/" + lang + ".json", false);
        }
    }

    public static String translate(String str, Object ... args) {
        String s;
        boolean isDebug = SmileyPlayerTrader.getInstance().getConfiguration().getDebugI18NAlerts();
        if (SmileyPlayerTrader.getInstance().getI18N().language.has(str)) {
            s = SmileyPlayerTrader.getInstance().getI18N().language.get(str).getAsString();
        } else {
            SmileyPlayerTrader.getInstance().getLogger().warning("Key '" + str + "' was not found in translation file!");
            s = str;
            if (isDebug) {
                s = ChatColor.DARK_RED.toString() + ChatColor.BOLD + "! " + ChatColor.RESET + s;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            s = s.replace("%" + i + "%", "" + args[i]);
        }
        s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        return s;
    }

    public static BaseComponent translateComponents(String str, BaseComponent ... args) {
        String s;
        boolean isDebug = SmileyPlayerTrader.getInstance().getConfiguration().getDebugI18NAlerts();
        if (SmileyPlayerTrader.getInstance().getI18N().language.has(str)) {
            s = SmileyPlayerTrader.getInstance().getI18N().language.get(str).getAsString();
        } else {
            SmileyPlayerTrader.getInstance().getLogger().warning("Key '" + str + "' was not found in translation file!");
            s = str;
            if (isDebug) {
                s = ChatColor.DARK_RED.toString() + ChatColor.BOLD + "! " + ChatColor.RESET + s;
            }
        }
        return I18N.parseTranslationStringToComponent(s, args);
    }

    public static BaseComponent parseTranslationStringToComponent(String s, BaseComponent ... args) {
        TextComponent baseSection;
        TextComponent section = baseSection = new TextComponent();
        StringBuilder builder = new StringBuilder();
        char[] chrArray = s.toCharArray();
        for (int i = 0; i < chrArray.length; ++i) {
            char chr = chrArray[i];
            if (chr == '%') {
                char digit;
                int argIndex = 0;
                int place = 1;
                int chrIndex = i;
                while (Character.isDigit(digit = chrArray[++chrIndex])) {
                    argIndex += (digit - 48) * place;
                    place *= 10;
                }
                if (digit != '%') {
                    builder.append('%');
                    continue;
                }
                if (argIndex >= args.length) {
                    builder.append('%').append(argIndex).append('%');
                } else {
                    section.setText(builder.toString());
                    section.addExtra(args[argIndex]);
                    TextComponent newSection = new TextComponent();
                    section.addExtra((BaseComponent)newSection);
                    section = newSection;
                    builder = new StringBuilder();
                }
                i = chrIndex;
                continue;
            }
            if (chr == '&' || chr == '\u00a7') {
                chr = Character.toLowerCase(chrArray[++i]);
                if (builder.length() != 0) {
                    section.setText(builder.toString());
                    TextComponent newSection = new TextComponent();
                    section.addExtra((BaseComponent)newSection);
                    section = newSection;
                    builder = new StringBuilder();
                }
                switch (chr) {
                    case 'l': {
                        section.setBold(Boolean.valueOf(true));
                        break;
                    }
                    case 'n': {
                        section.setUnderlined(Boolean.valueOf(true));
                        break;
                    }
                    case 'o': {
                        section.setItalic(Boolean.valueOf(true));
                        break;
                    }
                    case 'k': {
                        section.setObfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case 'm': {
                        section.setStrikethrough(Boolean.valueOf(true));
                        break;
                    }
                    case 'r': {
                        section.setBold(Boolean.valueOf(false));
                        section.setUnderlined(Boolean.valueOf(false));
                        section.setItalic(Boolean.valueOf(false));
                        section.setObfuscated(Boolean.valueOf(false));
                        section.setStrikethrough(Boolean.valueOf(false));
                        section.setColor(net.md_5.bungee.api.ChatColor.WHITE);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '9': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        section.setColor(ChatColor.getByChar((char)chr).asBungee());
                    }
                }
                continue;
            }
            builder.append(chr);
        }
        section.setText(builder.toString());
        return baseSection;
    }
}

