/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.versions;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.merchant.MerchantRecipe;
import io.github.mrcomputer1.smileyplayertrader.versions.IMCVersion;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_15;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_16;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_16_R2;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_16_R3;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_17;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_18;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_18_R2;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_19;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_19_1;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_19_R2;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_19_R3;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_20;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_20_R2;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_20_R3;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_20_R4;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_21;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_21_R2;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_21_R3;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_21_R4;
import io.github.mrcomputer1.smileyplayertrader.versions.MCVersion1_21_R5;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class VersionSupport {
    private IMCVersion version;
    private static final List<VersionSupportMeta> supportedVersions = new ArrayList<VersionSupportMeta>();

    public static void registerSupportedVersion(Callable<Boolean> isSupported, Supplier<? extends IMCVersion> versionSupplier) {
        supportedVersions.add(new VersionSupportMeta(isSupported, versionSupplier));
    }

    private static IMCVersion getBoundVersion() {
        return SmileyPlayerTrader.getInstance().getVersionSupport().version;
    }

    public static ItemStack byteArrayToItemStack(byte[] array) throws InvocationTargetException {
        return VersionSupport.getBoundVersion().byteArrayToItemStack(array);
    }

    public static byte[] itemStackToByteArray(ItemStack itemStack) throws InvocationTargetException {
        return VersionSupport.getBoundVersion().itemStackToByteArray(itemStack);
    }

    public static void setRecipesOnMerchant(Merchant merchant, List<MerchantRecipe> recipes) throws InvocationTargetException {
        VersionSupport.getBoundVersion().setRecipesOnMerchant(merchant, recipes);
    }

    public static int getSpecialCountForRecipe(MerchantInventory inventory) throws InvocationTargetException {
        return VersionSupport.getBoundVersion().getSpecialCountForRecipe(inventory);
    }

    public static ItemStack getMerchantRecipeOriginalResult(org.bukkit.inventory.MerchantRecipe merchantRecipe) {
        return VersionSupport.getBoundVersion().getMerchantRecipeOriginalResult(merchantRecipe);
    }

    public static String getPreferredItemName(ItemMeta itemMeta) {
        return VersionSupport.getBoundVersion().getPreferredItemName(itemMeta);
    }

    public void bindCompatibleVersion() throws IllegalStateException {
        if (this.version != null) {
            throw new IllegalStateException("Already bound version.");
        }
        String mcVersion = Bukkit.getBukkitVersion().split("-")[0];
        SmileyPlayerTrader.getInstance().getLogger().info("Bukkit version is '" + Bukkit.getBukkitVersion() + "', detected Minecraft version is '" + mcVersion + "'.");
        for (VersionSupportMeta version : supportedVersions) {
            try {
                if (!version.isSupported.call().booleanValue()) continue;
                this.version = version.versionSupplier.get();
                return;
            }
            catch (Exception ex) {
                SmileyPlayerTrader.getInstance().getLogger().warning("Unexpected exception in version support check, trying next version...");
                ex.printStackTrace();
            }
        }
        throw new IllegalStateException("No supported version was found.");
    }

    static {
        String bukkitVersion = Bukkit.getBukkitVersion();
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.15").matcher(bukkitVersion).find(), MCVersion1_15::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.16(\\.1)?-").matcher(bukkitVersion).find(), MCVersion1_16::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.16\\.[23]-").matcher(bukkitVersion).find(), MCVersion1_16_R2::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.16\\.[45]-").matcher(bukkitVersion).find(), MCVersion1_16_R3::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.17").matcher(bukkitVersion).find(), MCVersion1_17::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.18(\\.1)?-").matcher(bukkitVersion).find(), MCVersion1_18::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.18\\.2-").matcher(bukkitVersion).find(), MCVersion1_18_R2::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.19-").matcher(bukkitVersion).find(), MCVersion1_19::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.19\\.[12]-").matcher(bukkitVersion).find(), MCVersion1_19_1::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.19\\.3-").matcher(bukkitVersion).find(), MCVersion1_19_R2::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.19\\.4-").matcher(bukkitVersion).find(), MCVersion1_19_R3::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.20(\\.1)?-").matcher(bukkitVersion).find(), MCVersion1_20::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.20\\.2-").matcher(bukkitVersion).find(), MCVersion1_20_R2::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.20\\.[34]-").matcher(bukkitVersion).find(), MCVersion1_20_R3::new);
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.20\\.[56]-").matcher(bukkitVersion).find(), () -> new MCVersion1_20_R4((World)Bukkit.getWorlds().get(0)));
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.21(\\.[1])?-").matcher(bukkitVersion).find(), () -> new MCVersion1_21((World)Bukkit.getWorlds().get(0)));
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.21\\.[23]-").matcher(bukkitVersion).find(), () -> new MCVersion1_21_R2((World)Bukkit.getWorlds().get(0)));
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.21\\.4-").matcher(bukkitVersion).find(), () -> new MCVersion1_21_R3((World)Bukkit.getWorlds().get(0)));
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.21\\.5-").matcher(bukkitVersion).find(), () -> new MCVersion1_21_R4((World)Bukkit.getWorlds().get(0)));
        VersionSupport.registerSupportedVersion(() -> Pattern.compile("^1\\.21\\.[6-9]-").matcher(bukkitVersion).find(), () -> new MCVersion1_21_R5((World)Bukkit.getWorlds().get(0)));
    }

    private static class VersionSupportMeta {
        public final Callable<Boolean> isSupported;
        public final Supplier<? extends IMCVersion> versionSupplier;

        public VersionSupportMeta(Callable<Boolean> isSupported, Supplier<? extends IMCVersion> versionSupplier) {
            this.isSupported = isSupported;
            this.versionSupplier = versionSupplier;
        }
    }
}

