/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.EnderChestStockLocation;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.IStockLocation;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.InventoryStockLocation;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.ItemStorageStockLocation;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.NoOpStockLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;

public class StockLocations {
    private static final Map<String, IStockLocation> registeredStockLocations = new HashMap<String, IStockLocation>();
    private static final NoOpStockLocation NO_OP_STOCK_LOCATION = new NoOpStockLocation();

    public static IStockLocation getStockLocation(String id) {
        return registeredStockLocations.get(id);
    }

    public static void registerStockLocation(String id, IStockLocation stockLocation) {
        registeredStockLocations.put(id, stockLocation);
    }

    public static List<IStockLocation> getActiveStockLocations() {
        List<String> locations = SmileyPlayerTrader.getInstance().getConfiguration().getStockLocations();
        ArrayList<IStockLocation> stockLocations = new ArrayList<IStockLocation>();
        for (String location : locations) {
            IStockLocation stockLocation = StockLocations.getStockLocation(location);
            if (stockLocation == null) {
                SmileyPlayerTrader.getInstance().getLogger().warning("Invalid stock location '" + location + "'");
                continue;
            }
            stockLocations.add(stockLocation);
        }
        if (stockLocations.size() == 0) {
            stockLocations.add(NO_OP_STOCK_LOCATION);
            SmileyPlayerTrader.getInstance().getLogger().severe("No stock locations are active!");
        }
        return Collections.unmodifiableList(stockLocations);
    }

    public static boolean canTradeWithPlayer(OfflinePlayer player) {
        for (IStockLocation location : StockLocations.getActiveStockLocations()) {
            if (!location.isAvailable(player)) continue;
            return true;
        }
        return false;
    }

    static {
        StockLocations.registerStockLocation("inventory", new InventoryStockLocation());
        StockLocations.registerStockLocation("enderchest", new EnderChestStockLocation());
        StockLocations.registerStockLocation("itemstorage", new ItemStorageStockLocation());
    }
}

