/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import io.github.mrcomputer1.smileyplayertrader.util.merchant.MerchantUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPTPlaceholderExpansions
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return SmileyPlayerTrader.getInstance().getName();
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", SmileyPlayerTrader.getInstance().getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return SmileyPlayerTrader.getInstance().getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (params.equalsIgnoreCase("trades_all")) {
            return this.tradesAll(player);
        }
        if (params.equalsIgnoreCase("trades_all_everyone")) {
            return this.tradesAll(null);
        }
        if (params.equalsIgnoreCase("trades_active")) {
            return this.tradesActive(player);
        }
        if (params.equalsIgnoreCase("trades_active_everyone")) {
            return this.tradesActive(null);
        }
        if (params.equalsIgnoreCase("trades_inactive")) {
            return this.tradesInactive(player);
        }
        if (params.equalsIgnoreCase("trades_inactive_everyone")) {
            return this.tradesInactive(null);
        }
        if (params.equalsIgnoreCase("trades_hidden")) {
            return this.tradesHidden(player);
        }
        if (params.equalsIgnoreCase("trades_hidden_everyone")) {
            return this.tradesHidden(null);
        }
        if (params.equalsIgnoreCase("trades_disabled")) {
            return this.tradesDisabled(player);
        }
        if (params.equalsIgnoreCase("trades_disabled_everyone")) {
            return this.tradesDisabled(null);
        }
        if (params.equalsIgnoreCase("trades_in_stock")) {
            return this.tradesInStock(player);
        }
        if (params.equalsIgnoreCase("trades_out_of_stock")) {
            return this.tradesOutOfStock(player);
        }
        return null;
    }

    private String getCount(StatementHandler.StatementType type, Object ... params) {
        String string;
        block8: {
            ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(type, params);
            try {
                set.next();
                string = String.valueOf(set.getInt("count"));
                if (set == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            set.close();
        }
        return string;
    }

    private String tradesAll(OfflinePlayer player) {
        if (player != null) {
            return this.getCount(StatementHandler.StatementType.COUNT_ALL_PRODUCTS_FOR, player.getUniqueId().toString());
        }
        return this.getCount(StatementHandler.StatementType.COUNT_ALL_PRODUCTS_GLOBAL, new Object[0]);
    }

    private String tradesActive(OfflinePlayer player) {
        if (player != null) {
            return this.getCount(StatementHandler.StatementType.COUNT_PRODUCTS_FOR, player.getUniqueId().toString(), 1, 1);
        }
        return this.getCount(StatementHandler.StatementType.COUNT_PRODUCTS_GLOBAL, 1, 1);
    }

    private String tradesInactive(OfflinePlayer player) {
        if (player != null) {
            return this.getCount(StatementHandler.StatementType.COUNT_INACTIVE_PRODUCTS_FOR, player.getUniqueId().toString());
        }
        return this.getCount(StatementHandler.StatementType.COUNT_INACTIVE_PRODUCTS_GLOBAL, new Object[0]);
    }

    private String tradesHidden(OfflinePlayer player) {
        if (player != null) {
            return this.getCount(StatementHandler.StatementType.COUNT_PRODUCTS_FOR, player.getUniqueId().toString(), 0, 0);
        }
        return this.getCount(StatementHandler.StatementType.COUNT_PRODUCTS_GLOBAL, 0, 0);
    }

    private String tradesDisabled(OfflinePlayer player) {
        if (player != null) {
            return this.getCount(StatementHandler.StatementType.COUNT_PRODUCTS_FOR, player.getUniqueId().toString(), 1, 0);
        }
        return this.getCount(StatementHandler.StatementType.COUNT_PRODUCTS_GLOBAL, 1, 0);
    }

    private String tradesInStock(OfflinePlayer player) {
        String string;
        block10: {
            if (player == null) {
                return "Error: No player.";
            }
            ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.FIND_PRODUCTS, player.getUniqueId().toString());
            try {
                int count = 0;
                while (set.next()) {
                    ItemStack is;
                    byte[] productb;
                    if (!set.getBoolean("enabled") || !set.getBoolean("available")) continue;
                    int purchaseLimit = set.getInt("purchase_limit");
                    int purchaseCount = set.getInt("purchase_count");
                    if (purchaseLimit != -1 && purchaseCount >= purchaseLimit || (productb = set.getBytes("product")) == null || (is = MerchantUtil.buildItem(productb)) == null || !ItemUtil.doesPlayerHaveItem(player, is, set.getLong("id"))) continue;
                    ++count;
                }
                string = String.valueOf(count);
                if (set == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            set.close();
        }
        return string;
    }

    private String tradesOutOfStock(OfflinePlayer player) {
        String string;
        block10: {
            if (player == null) {
                return "Error: No player.";
            }
            ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.FIND_PRODUCTS, player.getUniqueId().toString());
            try {
                int count = 0;
                while (set.next()) {
                    ItemStack is;
                    byte[] productb;
                    if (!set.getBoolean("enabled") || !set.getBoolean("available")) continue;
                    int purchaseLimit = set.getInt("purchase_limit");
                    int purchaseCount = set.getInt("purchase_count");
                    if (purchaseLimit != -1 && purchaseCount >= purchaseLimit || (productb = set.getBytes("product")) == null || (is = MerchantUtil.buildItem(productb)) == null || ItemUtil.doesPlayerHaveItem(player, is, set.getLong("id"))) continue;
                    ++count;
                }
                string = String.valueOf(count);
                if (set == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            set.close();
        }
        return string;
    }
}

