/*
 * Decompiled with CFR 0.152.
 */
package dogloverpink.selectorUtils;

import dogloverpink.selectors.AllSelector;
import dogloverpink.selectors.ClosestSelector;
import dogloverpink.selectors.RandomSelector;
import dogloverpink.selectors.Selector;
import dogloverpink.selectors.SelfSelector;
import dogloverpink.specifications.DistanceSpecification;
import dogloverpink.specifications.GamemodeSpecification;
import dogloverpink.specifications.LevelSpecification;
import dogloverpink.specifications.LimitSpecification;
import dogloverpink.specifications.SelectorSpecification;
import dogloverpink.specifications.TagSpecification;
import dogloverpink.specifications.TeamSpecification;
import dogloverpink.specifications.WorldSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SelectorUtils {
    public static Map<String, SelectorSpecification> specifications = new HashMap<String, SelectorSpecification>();
    public static Map<Character, Selector> selectors = new HashMap<Character, Selector>();

    public static void EssXSelectorsInit() {
        SelectorUtils.addSelector('a', new AllSelector());
        SelectorUtils.addSelector('r', new RandomSelector());
        SelectorUtils.addSelector('p', new ClosestSelector());
        SelectorUtils.addSelector('s', new SelfSelector());
        SelectorUtils.addSpecification("gamemode", new GamemodeSpecification());
        SelectorUtils.addSpecification("tag", new TagSpecification());
        SelectorUtils.addSpecification("distance", new DistanceSpecification());
        SelectorUtils.addSpecification("team", new TeamSpecification());
        SelectorUtils.addSpecification("limit", new LimitSpecification());
        SelectorUtils.addSpecification("level", new LevelSpecification());
        SelectorUtils.addSpecification("world", new WorldSpecification());
    }

    public static void addSelector(char selectorLetter, Selector selector) {
        selectors.put(Character.valueOf(selectorLetter), selector);
    }

    public static void addSpecification(String specificationName, SelectorSpecification specification) {
        specifications.put(specificationName, specification);
    }

    public static boolean isInRadius(Location location, Player player, Double distance) {
        try {
            return location.distanceSquared(player.getLocation()) <= distance * distance;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, String> parseSelectorArguments(String selectorArguments) {
        String[] parts;
        HashMap<String, String> arguments = new HashMap<String, String>();
        if (selectorArguments.length() < 3) {
            return arguments;
        }
        for (String part : parts = selectorArguments.substring(3, selectorArguments.length()).split(",")) {
            String[] keyValue = part.split("=");
            if (keyValue.length != 2) continue;
            String value = keyValue[1];
            if (value.endsWith("]")) {
                value = value.substring(0, value.length() - 1);
            }
            arguments.put(keyValue[0], value);
        }
        return arguments;
    }

    public static void handleSelector(CommandSender sender, ArrayList<Player> players, String selectorString) {
        Selector selector = selectors.get(Character.valueOf(selectorString.charAt(1)));
        if (selector == null) {
            sender.sendMessage("\u00a7cInvalid selector: @" + selectorString.charAt(1) + "!");
            players.clear();
            return;
        }
        selector.evalute(players, sender);
    }

    public static ArrayList<Player> handleSpecifications(CommandSender sender, ArrayList<Player> players, String specifications) {
        Map<String, String> selectorArguments = SelectorUtils.parseSelectorArguments(specifications);
        for (String specification : selectorArguments.keySet()) {
            SelectorSpecification selectorSpecification = SelectorUtils.specifications.get(specification);
            if (selectorSpecification == null) {
                sender.sendMessage("\u00a7cInvalid selector specification: " + specification + ", ignoring it!");
                continue;
            }
            String specificationValue = selectorArguments.get(specification);
            if (!specificationValue.contains("&") && !specificationValue.contains("|")) {
                if (specificationValue.charAt(0) == '!') {
                    specificationValue = specificationValue.substring(1);
                    players.removeAll(selectorSpecification.evalute(players, specificationValue, sender));
                    continue;
                }
                players = selectorSpecification.evalute(players, specificationValue, sender);
                continue;
            }
            if (specificationValue.contains("|")) {
                Matcher orMapper = Pattern.compile("[^|&]+(?![^&]*$)").matcher(specificationValue + "&");
                ArrayList<Player> newPlayers = new ArrayList<Player>();
                while (orMapper.find()) {
                    String group = orMapper.group();
                    if (group.charAt(0) == '!') {
                        group = group.substring(1);
                        newPlayers = new ArrayList<Object>(players);
                        newPlayers.removeAll(selectorSpecification.evalute(newPlayers, group, sender));
                        continue;
                    }
                    newPlayers.addAll(selectorSpecification.evalute(players, group, sender));
                }
                players = newPlayers;
            }
            Matcher andMatcher = specificationValue.contains("|") ? Pattern.compile("(?<=&)[^&]+").matcher(specificationValue) : Pattern.compile("(?<=&|^)[^&]+").matcher(specificationValue);
            while (andMatcher.find()) {
                String group = andMatcher.group();
                if (group.charAt(0) == '!') {
                    group = group.substring(1);
                    players.removeAll(selectorSpecification.evalute(players, group, sender));
                    continue;
                }
                players.retainAll(selectorSpecification.evalute(players, group, sender));
            }
            players = new ArrayList(players.stream().distinct().toList());
        }
        return players;
    }
}

