/*
 * Decompiled with CFR 0.152.
 */
package dogloverpink.specifications;

import dogloverpink.selectorUtils.SelectorUtils;
import dogloverpink.specifications.SelectorSpecification;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DistanceSpecification
extends SelectorSpecification {
    @Override
    public ArrayList<Player> evalute(ArrayList<Player> players, String specificationValue, CommandSender sender) {
        ArrayList<Player> playersCopy = new ArrayList<Player>(players);
        try {
            Location senderLocation;
            if (specificationValue.startsWith("..")) {
                specificationValue = specificationValue.substring(2);
            }
            double distance = Double.parseDouble(specificationValue);
            if (sender instanceof Player) {
                senderLocation = ((Player)sender).getLocation();
            } else if (sender instanceof BlockCommandSender) {
                senderLocation = ((BlockCommandSender)sender).getBlock().getLocation();
            } else {
                sender.sendMessage("\u00a7cConsole can't use distance specification!");
                return playersCopy;
            }
            playersCopy.removeIf(player -> !SelectorUtils.isInRadius(senderLocation, player, distance));
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid distance specification! (Ignoring it!)");
            return playersCopy;
        }
        return playersCopy;
    }
}

