/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrankmenu.libs.axapi.utils;

import com.artillexstudios.axrankmenu.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axrankmenu.libs.axapi.utils.server.ServerImplementation;
import com.artillexstudios.axrankmenu.libs.axapi.utils.server.ServerImplementationPaper;
import com.artillexstudios.axrankmenu.libs.axapi.utils.server.ServerImplementationSpigot;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public final class PaperUtils {
    private static final ServerImplementation IMPLEMENTATION = ClassUtils.INSTANCE.classExists("io.papermc.paper.configuration.Configuration") || ClassUtils.INSTANCE.classExists("com.destroystokyo.paper.PaperConfig") ? new ServerImplementationPaper() : new ServerImplementationSpigot();
    private static final boolean FOLIA = ClassUtils.INSTANCE.classExists("io.papermc.paper.threadedregions.RegionizedServer");

    public static CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        return IMPLEMENTATION.teleportAsync(entity, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause cause) {
        return IMPLEMENTATION.teleportAsync(entity, location, cause);
    }

    public static CompletableFuture<Chunk> getChunkAtAsync(Location location) {
        return IMPLEMENTATION.getChunkAtAsync(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, true);
    }

    public static CompletableFuture<Chunk> getChunkAtAsync(Location location, boolean gen) {
        return IMPLEMENTATION.getChunkAtAsync(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, gen);
    }

    public static CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z) {
        return IMPLEMENTATION.getChunkAtAsync(world, x, z, true);
    }

    public static CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z, boolean gen) {
        return IMPLEMENTATION.getChunkAtAsync(world, x, z, gen, false);
    }

    public static CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z, boolean gen, boolean isUrgent) {
        return IMPLEMENTATION.getChunkAtAsync(world, x, z, gen, isUrgent);
    }

    public static CompletableFuture<Chunk> getChunkAtAsyncUrgently(World world, int x, int z, boolean gen) {
        return IMPLEMENTATION.getChunkAtAsync(world, x, z, gen, true);
    }

    public static boolean isChunkGenerated(Location location) {
        return PaperUtils.isChunkGenerated(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public static boolean isChunkGenerated(World world, int x, int z) {
        return IMPLEMENTATION.isChunkGenerated(world, x, z);
    }

    public static InventoryHolder getHolder(Inventory inventory, boolean useSnapshot) {
        return IMPLEMENTATION.getHolder(inventory, useSnapshot);
    }

    public static boolean isPaper() {
        return IMPLEMENTATION instanceof ServerImplementationPaper;
    }

    public static boolean isFolia() {
        return FOLIA;
    }
}

