/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.brigadier;

import java.util.Objects;
import java.util.function.Function;
import revxrsal.commands.bukkit.BukkitCommandHandler;
import revxrsal.commands.bukkit.brigadier.BukkitVersion;
import revxrsal.commands.bukkit.brigadier.Commodore;
import revxrsal.commands.bukkit.brigadier.PaperCommodore;
import revxrsal.commands.bukkit.brigadier.PaperLifecycleEvents;
import revxrsal.commands.bukkit.brigadier.ReflectionCommodore;

public final class CommodoreProvider {
    private static final Function<BukkitCommandHandler, Commodore> PROVIDER = CommodoreProvider.checkSupported();

    private CommodoreProvider() {
        throw new AssertionError();
    }

    private static Function<BukkitCommandHandler, Commodore> checkSupported() {
        if (!BukkitVersion.isBrigadierSupported()) {
            return null;
        }
        if (BukkitVersion.isPaper()) {
            if (BukkitVersion.supports(1, 20, 6)) {
                return plugin -> new PaperLifecycleEvents((BukkitCommandHandler)plugin);
            }
            if (BukkitVersion.supports(1, 19)) {
                return plugin -> new PaperCommodore((BukkitCommandHandler)plugin);
            }
        }
        return plugin -> new ReflectionCommodore((BukkitCommandHandler)plugin);
    }

    public static boolean isSupported() {
        return PROVIDER != null;
    }

    public static Commodore getCommodore(BukkitCommandHandler plugin) {
        Objects.requireNonNull(plugin, "plugin");
        return PROVIDER == null ? null : PROVIDER.apply(plugin);
    }
}

