/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.mysticcreations.true_end.TrueEnd;
import org.jetbrains.annotations.NotNull;

public class CreditsScreen
extends Screen {
    private static final ResourceLocation TITLE_TEX = ResourceLocation.parse((String)"true_end:textures/gui/title.png");
    private static final ResourceLocation TEXT_FILE = ResourceLocation.parse((String)"true_end:texts/credits.txt");
    private static final ResourceLocation BG_TEXTURE = ResourceLocation.parse((String)"true_end:textures/block/old_dirt.png");
    private static final String ALLOWED_SYMBOLS = "~_-=+!@#$%^&*()/\\?<>.,[]{};':\"|";
    private final Runnable onClose;
    private final List<String> lines = new ArrayList<String>();
    private float scroll = 0.0f;

    public CreditsScreen() {
        this(() -> {
            Minecraft.m_91087_().m_91106_().m_120405_();
            Minecraft.m_91087_().m_91152_(null);
        });
    }

    public CreditsScreen(Runnable onClose) {
        super((Component)Component.m_237119_());
        this.onClose = onClose;
        this.loadCreditsText();
        this.scroll = 0.0f;
    }

    private void loadCreditsText() {
        try (InputStream stream = Minecraft.m_91087_().m_91098_().m_215595_(TEXT_FILE);
             BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = br.readLine()) != null) {
                assert (Minecraft.m_91087_().f_91074_ != null);
                String replaced = line.replace("PLAYERNAME", Minecraft.m_91087_().f_91074_.m_7755_().getString());
                this.lines.add(this.filterFile(replaced));
            }
        }
        catch (Exception e) {
            TrueEnd.LOGGER.error("Failed to read credits.txt", (Throwable)e);
        }
    }

    private String filterFile(String line) {
        if (line == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(line.length());
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\u00a7') {
                sb.append(c);
                if (i + 1 >= line.length()) continue;
                sb.append(line.charAt(i + 1));
                ++i;
                continue;
            }
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ' ') && ALLOWED_SYMBOLS.indexOf(c) < 0) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_280273_(@NotNull GuiGraphics gui) {
        Minecraft mc = Minecraft.m_91087_();
        int scaledWidth = mc.m_91268_().m_85445_();
        int scaledHeight = mc.m_91268_().m_85446_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int texSize = 48;
        for (int x = 0; x < scaledWidth; x += texSize) {
            for (int y = 0; y < scaledHeight; y += texSize) {
                gui.m_280163_(BG_TEXTURE, x, y, 0.0f, 0.0f, texSize, texSize, texSize, texSize);
            }
        }
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        Minecraft mc = Minecraft.m_91087_();
        int scaledWidth = mc.m_91268_().m_85445_();
        int scaledHeight = mc.m_91268_().m_85446_();
        gui.m_280509_(0, 0, scaledWidth, scaledHeight, -2013265920);
        float scrollSpeed = 20.0f;
        this.scroll += scrollSpeed * (partialTicks / 20.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TITLE_TEX);
        int texW = 256;
        int texH = 64;
        float titleX = (float)(scaledWidth - texW) / 2.0f;
        float titleY = (float)scaledHeight - this.scroll;
        if (titleY + (float)texH > 0.0f && titleY < (float)scaledHeight) {
            gui.m_280163_(TITLE_TEX, (int)titleX, (int)titleY, 0.0f, 0.0f, texW, texH, texW, texH);
        }
        float startY = titleY + (float)texH + 20.0f;
        for (int i = 0; i < this.lines.size(); ++i) {
            float lineY = startY + (float)(i * 12);
            if (lineY + 12.0f < 0.0f) continue;
            if (lineY > (float)scaledHeight) break;
            String s = this.lines.get(i);
            int w = this.f_96547_.m_92895_(s);
            gui.m_280056_(this.f_96547_, s, (scaledWidth - w) / 2, (int)lineY, 0xFFFFFF, true);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose.run();
            return true;
        }
        return false;
    }
}

