/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.config.serializer;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public abstract class ConfigSerializer {
    private final File configFile;
    private final String extension;

    public ConfigSerializer(String configFileName, String extension) {
        this.extension = extension;
        extension = "." + (String)extension;
        this.configFile = FMLPaths.CONFIGDIR.get().resolve((String)(configFileName.endsWith((String)extension) ? configFileName : configFileName + (String)extension)).toFile();
    }

    protected File getConfigFile() {
        return this.configFile;
    }

    public abstract void serialize(Map<String, Object> var1);

    public abstract Map<String, Object> deserialize();

    protected void createConfigFile() {
        try {
            this.getConfigFile().createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getMessage() {
        return "Loaded " + this.extension.toUpperCase() + " config file " + this.getConfigFile().toPath();
    }
}

