/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.entity;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mysticcreations.true_end.network.Variables;

public class Unknown
extends AmbientCreature {
    private static final double FOLLOW_RANGE = 128.0;
    private static final int MAX_VISIBLE_TICKS = 60;
    private static final int COOLDOWN_TICKS = 3600;
    private int visibleTicks = 0;
    private int existenceTicks = 0;
    private UnknownBehavior behavior = UnknownBehavior.STALKING;
    private static final EntityDataAccessor<String> TEXTURE_NAME = SynchedEntityData.m_135353_(Unknown.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public Unknown(EntityType<? extends AmbientCreature> type, Level level) {
        super(type, level);
        this.m_21530_();
        this.f_21344_ = new GroundPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6673_(DamageSource source) {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TEXTURE_NAME, (Object)"unknown_0");
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.behavior = UnknownBehavior.fromString(tag.m_128461_("Behavior"));
        if (tag.m_128471_("doWeeping")) {
            this.behavior = UnknownBehavior.WEEPING;
        }
        if (tag.m_128471_("doStalking")) {
            this.behavior = UnknownBehavior.STALKING;
        }
        if (tag.m_128471_("doAttacking")) {
            this.behavior = UnknownBehavior.ATTACKING;
        }
        this.setBehavior(this.behavior);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Behavior", this.behavior.name());
        tag.m_128379_("doWeeping", this.behavior == UnknownBehavior.WEEPING);
        tag.m_128379_("doStalking", this.behavior == UnknownBehavior.STALKING);
        tag.m_128379_("doAttacking", this.behavior == UnknownBehavior.ATTACKING);
    }

    public void m_8119_() {
        super.m_8119_();
        if (++this.existenceTicks >= 3600 && this.behavior == UnknownBehavior.STALKING) {
            this.playAndDespawn();
            return;
        }
        Player target = this.m_9236_().m_45930_((Entity)this, 128.0);
        if (target == null) {
            return;
        }
        if (this.m_20270_((Entity)target) < 9.0f && !target.m_21023_(MobEffects.f_216964_)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 100, 0, false, false));
        }
        switch (this.behavior) {
            case STALKING: {
                this.doStalking(target);
                break;
            }
            case WEEPING: {
                this.doWeeping(target);
                break;
            }
            case ATTACKING: {
                this.doAttacking(target);
                break;
            }
            default: {
                this.doStalking(target);
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new LookAtNearestPlayerGoal((Mob)this));
    }

    private void doStalking(Player player) {
        if (this.m_20270_((Entity)player) <= 16.0f) {
            this.playAndDespawn();
            return;
        }
        Vec3 toEntity = this.m_20182_().m_82546_(player.m_20182_()).m_82541_();
        double angle = Math.toDegrees(Math.acos(toEntity.m_82526_(player.m_20154_().m_82541_())));
        if (this.m_142582_((Entity)player) && angle < 12.0 && ++this.visibleTicks >= 60) {
            this.playAndDespawn();
        } else if (!this.m_142582_((Entity)player) || angle >= 4.0) {
            this.visibleTicks = 0;
        }
        this.m_21573_().m_26573_();
    }

    private void doWeeping(Player player) {
        boolean seen;
        if (this.m_20270_((Entity)player) <= 3.0f) {
            this.playAndDespawn();
            return;
        }
        Vec3 toEntity = this.m_20182_().m_82546_(player.m_20182_()).m_82541_();
        double angle = Math.toDegrees(Math.acos(toEntity.m_82526_(player.m_20154_().m_82541_())));
        boolean bl = seen = this.m_142582_((Entity)player) && angle < 30.0;
        if (!seen) {
            this.m_21573_().m_5624_((Entity)player, 0.5025);
        } else {
            this.m_21573_().m_26573_();
        }
    }

    private void doAttacking(Player player) {
        this.m_21573_().m_5624_((Entity)player, 0.75);
        if ((double)this.m_20270_((Entity)player) < 1.5 && player.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_())) {
            this.playAndDespawn();
        }
    }

    private void playAndDespawn() {
        this.m_21573_().m_26573_();
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.MASTER, 1.0f, 1.0f);
        Variables.MapVariables.get((LevelAccessor)server).setUnknownInWorld(false);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        this.m_9236_().m_46672_(this.m_20183_(), state.m_60734_());
    }

    public void setBehavior(UnknownBehavior texture) {
        this.behavior = texture;
        String[] textures = switch (texture) {
            case UnknownBehavior.STALKING -> new String[]{"unknown_0", "unknown_1"};
            case UnknownBehavior.WEEPING -> new String[]{"unknown_3"};
            case UnknownBehavior.ATTACKING -> new String[]{"unknown_0", "unknown_2"};
            default -> new String[]{"unknown_0", "unknown_1"};
        };
        String selected = textures[new Random().nextInt(textures.length)];
        this.f_19804_.m_135381_(TEXTURE_NAME, (Object)selected);
    }

    public String getTextureName() {
        return (String)this.f_19804_.m_135370_(TEXTURE_NAME);
    }

    public static enum UnknownBehavior {
        STALKING,
        WEEPING,
        ATTACKING;


        public static UnknownBehavior fromString(String s) {
            try {
                return UnknownBehavior.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return STALKING;
            }
        }
    }

    private static class LookAtNearestPlayerGoal
    extends Goal {
        private final Mob mob;

        LookAtNearestPlayerGoal(Mob mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_9236_().m_45930_((Entity)this.mob, 128.0) != null;
        }

        public void m_8037_() {
            Player player = this.mob.m_9236_().m_45930_((Entity)this.mob, 128.0);
            if (player != null) {
                this.mob.m_21563_().m_24946_(player.m_20185_(), player.m_20188_(), player.m_20189_());
            }
        }
    }
}

