/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures.alphaFeatures;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.mysticcreations.true_end.init.Dimensions;

@Mod.EventBusSubscriber
public class AlphaFoodSystem {
    public static final Map<Item, Float> FOOD_MAP = new ConcurrentHashMap<Item, Float>();

    @SubscribeEvent
    public static int onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        return AlphaFoodSystem.processInteraction((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static int onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        return AlphaFoodSystem.processInteraction((PlayerInteractEvent)event);
    }

    private static int processInteraction(PlayerInteractEvent event) {
        Player player = event.getEntity();
        if (player == null) {
            return 0;
        }
        if (player.m_9236_().m_46472_() != Dimensions.BTD) {
            return 0;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return 0;
        }
        Item item = stack.m_41720_();
        Float heal = FOOD_MAP.get(item);
        int consumed = 2;
        if (heal != null) {
            consumed = 1;
        } else if (stack.m_41614_()) {
            consumed = 0;
        }
        if (consumed == 1) {
            float newHealth = player.m_21223_() + heal.floatValue();
            if (!AlphaFoodSystem.healthCheck(player, event)) {
                stack.m_41774_(1);
                player.m_150109_().m_6596_();
                float maxHealth = player.m_21233_();
                player.m_21153_(Math.min(newHealth, maxHealth));
                AlphaFoodSystem.playEatSound((LevelAccessor)player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
            } else {
                consumed = 0;
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        } else if (consumed == 0 && event.isCancelable()) {
            event.setCanceled(true);
        }
        return consumed;
    }

    private static void playEatSound(LevelAccessor world, double x, double y, double z) {
        double pitch = 0.8 + Math.random() * 0.4;
        if (world instanceof Level) {
            Level level = (Level)world;
            if (!level.m_5776_()) {
                level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.generic.eat"))), SoundSource.NEUTRAL, 1.0f, (float)pitch);
            } else {
                level.m_7785_(x, y, z, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.generic.eat"))), SoundSource.NEUTRAL, 1.0f, (float)pitch, false);
            }
        }
    }

    private static boolean healthCheck(Player player, PlayerInteractEvent event) {
        if (player.m_21223_() >= player.m_21233_()) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            return true;
        }
        return false;
    }

    static {
        FOOD_MAP.put(Items.f_42485_, Float.valueOf(1.5f));
        FOOD_MAP.put(Items.f_42486_, Float.valueOf(4.0f));
        FOOD_MAP.put(Items.f_42579_, Float.valueOf(3.0f));
        FOOD_MAP.put(Items.f_42580_, Float.valueOf(8.0f));
        FOOD_MAP.put(Items.f_42658_, Float.valueOf(2.0f));
        FOOD_MAP.put(Items.f_42659_, Float.valueOf(6.0f));
        FOOD_MAP.put(Items.f_42581_, Float.valueOf(2.0f));
        FOOD_MAP.put(Items.f_42582_, Float.valueOf(6.0f));
        FOOD_MAP.put(Items.f_42406_, Float.valueOf(2.5f));
        FOOD_MAP.put(Items.f_42410_, Float.valueOf(2.0f));
        FOOD_MAP.put(Items.f_42436_, Float.valueOf(10.0f));
    }
}

