/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures.randomEvents;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.TrueEnd;
import net.mysticcreations.true_end.network.Variables;

@Mod.EventBusSubscriber
public class MobStare {
    private static final Map<Mob, Integer> stareMap = new HashMap<Mob, Integer>();
    private static final Random RANDOM = new Random();
    private static long lastEventTick = 0L;
    private static final long EVENT_COOLDOWN = 96000L;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level world = event.level;
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        long worldTick = server.m_46467_();
        if (worldTick < lastEventTick + 96000L) {
            MobStare.updateStare(server);
            return;
        }
        if (Variables.doRandomEvents && stareMap.isEmpty() && RANDOM.nextDouble() < Variables.randomEventChance) {
            lastEventTick = worldTick;
            TrueEnd.LOGGER.info("[MobStare] Starting stare event");
            List players = server.m_6907_();
            int maxDuration = 0;
            for (ServerPlayer player : players) {
                AABB area = new AABB(player.m_20183_()).m_82400_(32.0);
                for (Mob mob : server.m_45976_(Mob.class, area)) {
                    int duration = 200 + RANDOM.nextInt(17801);
                    stareMap.put(mob, duration);
                    if (duration <= maxDuration) continue;
                    maxDuration = duration;
                }
            }
            double seconds = (double)maxDuration / 20.0;
            String human = seconds >= 60.0 ? String.format("%.1f minutes", seconds / 60.0) : String.format("%.1f seconds", seconds);
            TrueEnd.LOGGER.info("MobStare event executed / Lasting {} ticks (~{})", (Object)maxDuration, (Object)human);
        }
        MobStare.updateStare(server);
    }

    private static void updateStare(ServerLevel server) {
        Iterator<Map.Entry<Mob, Integer>> iter = stareMap.entrySet().iterator();
        List players = server.m_6907_();
        while (iter.hasNext()) {
            Map.Entry<Mob, Integer> entry = iter.next();
            Mob mob = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                iter.remove();
                continue;
            }
            entry.setValue(ticksLeft);
            PathNavigation nav = mob.m_21573_();
            nav.m_26573_();
            ServerPlayer closest = null;
            double bestDist = Double.MAX_VALUE;
            for (ServerPlayer p : players) {
                double d = mob.m_20270_((Entity)p);
                if (!(d < bestDist)) continue;
                bestDist = d;
                closest = p;
            }
            if (closest == null) continue;
            mob.m_21563_().m_24960_(closest, 30.0f, 30.0f);
        }
    }
}

