/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures.randomEvents.entitySpawning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.entity.Unknown;
import net.mysticcreations.true_end.init.Entities;
import net.mysticcreations.true_end.network.Variables;
import net.mysticcreations.true_end.procedures.advancement.NotAlone;

@Mod.EventBusSubscriber
public class SpawnShortAttack {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.player.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (Variables.MapVariables.get((LevelAccessor)world).isUnknownInWorld()) {
            return;
        }
        if (world.m_46467_() % 1200L != 0L) {
            return;
        }
        if (world.m_46472_() == Level.f_46430_) {
            return;
        }
        if (!Variables.doRandomEvents) {
            return;
        }
        if (!(world.f_46441_.m_188500_() < Variables.entitySpawnChance / 50.0)) {
            return;
        }
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        long daysPlayed = world.m_46467_() / 24000L;
        if (daysPlayed < 24L) {
            return;
        }
        List players = world.m_6907_();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)players.get(world.f_46441_.m_188503_(players.size()));
        double playerX = player.m_20185_();
        double playerY = player.m_20186_();
        double playerZ = player.m_20189_();
        EntityType type = (EntityType)Entities.UNKNOWN.get();
        Entity entity = type.m_20615_((Level)world);
        if (!(entity instanceof Unknown)) {
            return;
        }
        Unknown unknown = (Unknown)entity;
        entity.getPersistentData().m_128379_("PersistenceRequired", true);
        unknown.setBehavior(Unknown.UnknownBehavior.ATTACKING);
        ArrayList<String> directions = new ArrayList<String>();
        directions.add("EAST");
        directions.add("WEST");
        directions.add("SOUTH");
        directions.add("NORTH");
        Collections.shuffle(directions);
        for (String dir : directions) {
            if (world.f_46441_.m_188500_() >= 0.25) continue;
            double spawnX = playerX;
            double spawnZ = playerZ;
            spawnZ = switch (dir) {
                case "EAST" -> {
                    spawnX = playerX + 1.0;
                    yield playerZ;
                }
                case "WEST" -> {
                    spawnX = playerX - 1.0;
                    yield playerZ;
                }
                case "SOUTH" -> {
                    spawnX = playerX;
                    yield playerZ + 1.0;
                }
                case "NORTH" -> {
                    spawnX = playerX;
                    yield playerZ - 1.0;
                }
                default -> spawnZ;
            };
            double spawnY = playerY + 0.2;
            double entityDirZ = playerZ - spawnZ;
            double entityDirX = playerX - spawnX;
            float entityYaw = (float)(Math.toDegrees(Math.atan2(entityDirZ, entityDirX)) - 90.0);
            entity.m_7678_(spawnX, spawnY, spawnZ, entityYaw, 0.0f);
            break;
        }
        world.m_7967_(entity);
        if (!entity.m_213877_() && entity.m_9236_() == world) {
            Variables.MapVariables.get((LevelAccessor)world).setUnknownInWorld(true);
            NotAlone.grantAdvancement(player);
        }
    }
}

