/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures.randomEvents.entitySpawning;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.TrueEnd;
import net.mysticcreations.true_end.entity.Unknown;
import net.mysticcreations.true_end.init.Entities;
import net.mysticcreations.true_end.network.Variables;
import net.mysticcreations.true_end.procedures.advancement.NotAlone;

@Mod.EventBusSubscriber
public class SpawnStalking {
    private static final long TICK_INTERVAL = 1200L;
    private static final int MAX_ATTEMPTS = 16;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.player.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (Variables.MapVariables.get((LevelAccessor)world).isUnknownInWorld()) {
            return;
        }
        if (world.m_46467_() % 1200L != 0L) {
            return;
        }
        if (world.m_46472_() == Level.f_46430_) {
            return;
        }
        if (!Variables.doRandomEvents) {
            return;
        }
        long daysPlayed = world.m_46467_() / 24000L;
        if (daysPlayed < 10L) {
            return;
        }
        double difficultyMultiplier = switch (world.m_46791_()) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 3.0;
            case Difficulty.EASY -> 0.5;
            case Difficulty.NORMAL -> 1.0;
            case Difficulty.HARD -> 2.0;
        };
        double spawnChance = Variables.entitySpawnChance * difficultyMultiplier * (double)(daysPlayed - 10L);
        spawnChance = Math.min(spawnChance, 1.0);
        if (!(world.f_46441_.m_188500_() < spawnChance)) {
            return;
        }
        List players = world.m_6907_();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)players.get(world.f_46441_.m_188503_(players.size()));
        double maxDistance = (double)world.m_7654_().m_6846_().m_11312_() * 16.0 - 48.0;
        if (maxDistance <= 48.0) {
            return;
        }
        for (int attempt = 0; attempt < 16; ++attempt) {
            int z;
            int y;
            double angle = world.f_46441_.m_188500_() * Math.PI * 2.0;
            double dist = 32.0 + world.f_46441_.m_188500_() * (maxDistance - 32.0);
            double px = player.m_20185_();
            double pz = player.m_20189_();
            int x = Mth.m_14107_((double)(px + Math.cos(angle) * dist));
            BlockPos groundPos = new BlockPos(x, (y = world.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z = Mth.m_14107_((double)(pz + Math.sin(angle) * dist)))) - 1, z);
            BlockState groundState = world.m_8055_(groundPos);
            if (!groundState.m_60795_() && groundState.m_60734_() != Blocks.f_49990_ && groundState.m_60734_() != Blocks.f_49991_) {
                EntityType type = (EntityType)Entities.UNKNOWN.get();
                Entity entity = type.m_20615_((Level)world);
                if (entity == null) {
                    return;
                }
                if (!(entity instanceof Unknown)) {
                    return;
                }
                Unknown unknown = (Unknown)entity;
                entity.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, world.f_46441_.m_188501_() * 360.0f, 0.0f);
                entity.getPersistentData().m_128379_("PersistenceRequired", true);
                unknown.setBehavior(Unknown.UnknownBehavior.STALKING);
                world.m_7967_(entity);
                Variables.MapVariables.get((LevelAccessor)world).setUnknownInWorld(true);
                NotAlone.grantAdvancement(player);
                TrueEnd.LOGGER.info("Spawned 'Unknown' at {} on {}", (Object)entity.m_20183_(), (Object)groundState);
                return;
            }
            TrueEnd.LOGGER.debug("Attempt {}: invalid ground at {}: {}", (Object)attempt, (Object)groundPos, (Object)groundState.m_60734_());
        }
    }
}

