/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.mysticcreations.true_end.init.Blocks;

public class Farmland
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public Farmland() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60918_(SoundType.f_56739_).m_60978_(0.5f).m_60977_());
    }

    public BlockState m_7417_(BlockState p_53276_, Direction p_53277_, BlockState p_53278_, LevelAccessor p_53279_, BlockPos p_53280_, BlockPos p_53281_) {
        if (p_53277_ == Direction.UP && !p_53276_.m_60710_((LevelReader)p_53279_, p_53280_)) {
            p_53279_.m_186460_(p_53280_, (Block)this, 1);
        }
        return super.m_7417_(p_53276_, p_53277_, p_53278_, p_53279_, p_53280_, p_53281_);
    }

    public boolean m_7898_(BlockState p_53272_, LevelReader p_53273_, BlockPos p_53274_) {
        BlockState blockstate = p_53273_.m_8055_(p_53274_.m_7494_());
        return !blockstate.m_280296_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext p_53249_) {
        return !this.m_49966_().m_60710_((LevelReader)p_53249_.m_43725_(), p_53249_.m_8083_()) ? ((Block)Blocks.DIRT.get()).m_49966_() : super.m_5573_(p_53249_);
    }

    public boolean m_7923_(BlockState p_53295_) {
        return true;
    }

    public VoxelShape m_5940_(BlockState p_53290_, BlockGetter p_53291_, BlockPos p_53292_, CollisionContext p_53293_) {
        return SHAPE;
    }

    public void m_213897_(BlockState p_221134_, ServerLevel p_221135_, BlockPos p_221136_, RandomSource p_221137_) {
        if (!p_221134_.m_60710_((LevelReader)p_221135_, p_221136_)) {
            Farmland.turnToDirt(null, p_221134_, (Level)p_221135_, p_221136_);
        }
    }

    public void m_213898_(BlockState p_221139_, ServerLevel p_221140_, BlockPos p_221141_, RandomSource p_221142_) {
        int i = (Integer)p_221139_.m_61143_((Property)MOISTURE);
        if (!Farmland.isNearWater((LevelReader)p_221140_, p_221141_) && !p_221140_.m_46758_(p_221141_.m_7494_())) {
            if (i > 0) {
                p_221140_.m_7731_(p_221141_, (BlockState)p_221139_.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!Farmland.shouldMaintainFarmland((BlockGetter)p_221140_, p_221141_)) {
                Farmland.turnToDirt(null, p_221139_, (Level)p_221140_, p_221141_);
            }
        } else if (i < 7) {
            p_221140_.m_7731_(p_221141_, (BlockState)p_221139_.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level p_153227_, BlockState p_153228_, BlockPos p_153229_, Entity p_153230_, float p_153231_) {
        if (!p_153227_.f_46443_ && ForgeHooks.onFarmlandTrample((Level)p_153227_, (BlockPos)p_153229_, (BlockState)((Block)Blocks.DIRT.get()).m_49966_(), (float)p_153231_, (Entity)p_153230_)) {
            Farmland.turnToDirt(p_153230_, p_153228_, p_153227_, p_153229_);
        }
        super.m_142072_(p_153227_, p_153228_, p_153229_, p_153230_, p_153231_);
    }

    public static void turnToDirt(@Nullable Entity p_270981_, BlockState p_270402_, Level p_270568_, BlockPos p_270551_) {
        BlockState blockstate = Farmland.m_49897_((BlockState)p_270402_, (BlockState)((Block)Blocks.DIRT.get()).m_49966_(), (LevelAccessor)p_270568_, (BlockPos)p_270551_);
        p_270568_.m_46597_(p_270551_, blockstate);
        p_270568_.m_220407_(GameEvent.f_157792_, p_270551_, GameEvent.Context.m_223719_((Entity)p_270981_, (BlockState)blockstate));
    }

    private static boolean shouldMaintainFarmland(BlockGetter p_279219_, BlockPos p_279209_) {
        BlockState plant = p_279219_.m_8055_(p_279209_.m_7494_());
        BlockState state = p_279219_.m_8055_(p_279209_);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(p_279219_, p_279209_, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader p_53259_, BlockPos p_53260_) {
        BlockState state = p_53259_.m_8055_(p_53260_);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_53260_.m_7918_(-4, 0, -4), (BlockPos)p_53260_.m_7918_(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)p_53259_, p_53260_, p_53259_.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)p_53259_, (BlockPos)p_53260_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_53283_) {
        p_53283_.m_61104_(new Property[]{MOISTURE});
    }

    public boolean m_7357_(BlockState p_53267_, BlockGetter p_53268_, BlockPos p_53269_, PathComputationType p_53270_) {
        return false;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return true;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, IPlantable plantable) {
        return true;
    }
}

