/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.command.calls;

import java.io.File;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.loading.FMLPaths;

public class InvFileConvert {
    private static final File saveDir = FMLPaths.CONFIGDIR.get().resolve("true_end").toFile();

    private static String makeBackupFilename(ServerPlayer player, String suffix) {
        Path worldFolder = player.m_20194_().m_129843_(LevelResource.f_78178_).getParent();
        String folderName = worldFolder.getFileName().toString();
        String cleanName = folderName.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        String uuid = player.m_20148_().toString().replace("-", "");
        return uuid + "_" + cleanName + "_" + suffix + ".dat";
    }

    public static void execute(ServerPlayer player, String suffix) {
        try {
            String filename;
            File file;
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            if (!(file = new File(saveDir, filename = InvFileConvert.makeBackupFilename(player, suffix))).exists()) {
                player.m_213846_((Component)Component.m_237113_((String)("[True End] No backup file found for " + suffix)));
                player.m_213846_((Component)Component.m_237113_((String)("[True End] File: " + filename)));
                player.m_213846_((Component)Component.m_237113_((String)("[True End] File Path: " + String.valueOf(saveDir))));
                return;
            }
            CompoundTag root = NbtIo.m_128937_((File)file);
            if (root.m_128425_("CuriosInventory", 9) || !root.m_128425_("CuriosInventory", 10)) {
                player.m_213846_((Component)Component.m_237113_((String)"[True End] Your Inventory Backup is already up-to-date"));
                return;
            }
            CompoundTag oldInv = root.m_128469_("CuriosInventory");
            ListTag newCuriosList = new ListTag();
            if (oldInv.m_128425_("Curios", 9)) {
                ListTag handlerList = oldInv.m_128437_("Curios", 10);
                for (Tag htag : handlerList) {
                    CompoundTag stacks;
                    handlerCompound = (CompoundTag)htag;
                    String identifier = handlerCompound.m_128461_("Identifier");
                    CompoundTag stacksHandler = handlerCompound.m_128425_("StacksHandler", 10) ? handlerCompound.m_128469_("StacksHandler") : null;
                    if (stacksHandler == null || !stacksHandler.m_128425_("Stacks", 10) || !(stacks = stacksHandler.m_128469_("Stacks")).m_128425_("Items", 9)) continue;
                    ListTag items = stacks.m_128437_("Items", 10);
                    for (Tag it : items) {
                        CompoundTag itemEntry = (CompoundTag)it;
                        int slot = itemEntry.m_128441_("Slot") ? itemEntry.m_128451_("Slot") : 0;
                        CompoundTag itemCompound = itemEntry.m_6426_();
                        itemCompound.m_128473_("Slot");
                        CompoundTag newEntry = new CompoundTag();
                        newEntry.m_128359_("Handler", identifier);
                        newEntry.m_128405_("Slot", slot);
                        newEntry.m_128365_("Item", (Tag)itemCompound);
                        newCuriosList.add((Object)newEntry);
                    }
                }
            } else {
                for (String key : oldInv.m_128431_()) {
                    CompoundTag stacks;
                    CompoundTag stacksHandler;
                    Tag potential = oldInv.m_128423_(key);
                    if (!(potential instanceof CompoundTag) || !(stacksHandler = (handlerCompound = (CompoundTag)potential).m_128425_("StacksHandler", 10) ? handlerCompound.m_128469_("StacksHandler") : handlerCompound).m_128425_("Stacks", 10) || !(stacks = stacksHandler.m_128469_("Stacks")).m_128425_("Items", 9)) continue;
                    ListTag items = stacks.m_128437_("Items", 10);
                    for (Tag it : items) {
                        CompoundTag itemEntry = (CompoundTag)it;
                        int slot = itemEntry.m_128441_("Slot") ? itemEntry.m_128451_("Slot") : 0;
                        CompoundTag itemCompound = itemEntry.m_6426_();
                        itemCompound.m_128473_("Slot");
                        CompoundTag newEntry = new CompoundTag();
                        newEntry.m_128359_("Handler", key);
                        newEntry.m_128405_("Slot", slot);
                        newEntry.m_128365_("Item", (Tag)itemCompound);
                        newCuriosList.add((Object)newEntry);
                    }
                }
            }
            if (newCuriosList.isEmpty()) {
                player.m_213846_((Component)Component.m_237113_((String)"[True End] No Curios items were found to convert"));
                return;
            }
            CompoundTag newRoot = root.m_6426_();
            newRoot.m_128473_("CuriosInventory");
            newRoot.m_128365_("CuriosInventory", (Tag)newCuriosList);
            String oldName = file.getName();
            int dot = oldName.lastIndexOf(46);
            String base = dot >= 0 ? oldName.substring(0, dot) : oldName;
            File renamed = new File(file.getParentFile(), base + "_old.dat");
            if (!file.renameTo(renamed)) {
                renamed = new File(file.getParentFile(), base + "_old.dat");
            }
            NbtIo.m_128944_((CompoundTag)newRoot, (File)file);
            renamed.delete();
            player.m_213846_((Component)Component.m_237113_((String)"[True End] Your Inventory Backup has been converted"));
        }
        catch (Exception e) {
            e.printStackTrace();
            player.m_213846_((Component)Component.m_237113_((String)"[True End] Failed to convert your Inventory Backup - check server logs"));
        }
    }
}

