/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.config;

import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.TrueEnd;
import net.mysticcreations.true_end.config.serializer.GsonSerializer;
import net.mysticcreations.true_end.init.Packets;
import net.mysticcreations.true_end.network.Variables;
import net.mysticcreations.true_end.network.packets.UpdateClientConfigPacket;

@Mod.EventBusSubscriber
public class Config {
    public static final GsonSerializer serializer = new GsonSerializer("TrueEnd_COMMON");
    public static Map<String, Object> entries;

    public static void updateConfig(String key, Object value) {
        entries.put(key, value);
        serializer.serialize(entries);
        switch (key) {
            case "randomEventChance": {
                Variables.randomEventChance = (Double)value;
                break;
            }
            case "entitySpawnChance": {
                Variables.entitySpawnChance = (Double)value;
                break;
            }
            case "btdConversationDelay": {
                Variables.btdConversationDelay = (Integer)value;
                break;
            }
            case "creditsToggle": {
                Variables.creditsToggle = (Boolean)value;
                break;
            }
            case "fogToggle": {
                Variables.fogToggle = (Boolean)value;
                break;
            }
            case "popupsToggle": {
                Variables.popupsToggle = (Boolean)value;
                break;
            }
            case "daytimeChangeToggle": {
                Variables.daytimeChangeToggle = (Boolean)value;
                break;
            }
            case "clearDreamItems": {
                Variables.clearDreamItems = (Boolean)value;
                break;
            }
            case "flashingLights": {
                Variables.flashingLights = (Boolean)value;
                break;
            }
            case "doChatReplies": {
                Variables.doChatReplies = (Boolean)value;
                break;
            }
            default: {
                TrueEnd.LOGGER.warn("updateConfig: unhandled key '{}'", (Object)key);
            }
        }
    }

    public static int handleBoolean(CommandSourceStack src, String key, boolean value) {
        try {
            Config.updateConfig(key, value);
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("Failed to update config '" + key + "': " + e.getMessage())));
            return 0;
        }
        src.m_288197_(() -> Component.m_237113_((String)("Config '" + key + "' is now set to " + value)), false);
        return 1;
    }

    public static int handleDouble(CommandSourceStack src, String key, double value) {
        try {
            Config.updateConfig(key, value);
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("Failed to update config '" + key + "': " + e.getMessage())));
            return 0;
        }
        src.m_288197_(() -> Component.m_237113_((String)("Config '" + key + "' is now set to " + value)), false);
        return 1;
    }

    public static int handleInt(CommandSourceStack src, String key, int value) {
        try {
            Config.updateConfig(key, value);
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("Failed to update config '" + key + "': " + e.getMessage())));
            return 0;
        }
        src.m_288197_(() -> Component.m_237113_((String)("Config '" + key + "' is now set to " + value)), false);
        return 1;
    }

    public static void updateClientConfig(ServerPlayer player, CommandSourceStack src, String key, boolean value) {
        Config.updateConfig(key, value);
        Config.handleBoolean(src, key, value);
        if (player != null && !player.m_9236_().m_5776_()) {
            Packets.sendToPlayer(new UpdateClientConfigPacket(key, value), player);
        }
    }
}

