/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.config.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.mysticcreations.true_end.config.serializer.ConfigSerializer;

public class GsonSerializer
extends ConfigSerializer {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String extension = "json";

    public GsonSerializer(String configFileName) {
        super(configFileName, extension);
    }

    @Override
    public void serialize(Map<String, Object> entries) {
        try (FileWriter writer = new FileWriter(this.getConfigFile());){
            gson.toJson(entries, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> deserialize() {
        Map map;
        FileReader reader = new FileReader(this.getConfigFile());
        try {
            map = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.createConfigFile();
                return null;
            }
        }
        reader.close();
        return map;
    }
}

