/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures;

import io.wispforest.accessories.api.AccessoriesCapability;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.ItemHandlerHelper;
import net.mysticcreations.true_end.TrueEnd;
import net.mysticcreations.true_end.init.Dimensions;
import net.mysticcreations.true_end.init.Items;
import net.mysticcreations.true_end.network.Variables;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber
public class PlayerInvManager {
    private static final Random RAND = new Random();
    private static final File saveDir = FMLPaths.CONFIGDIR.get().resolve("true_end").toFile();

    private static String makeBackupFilename(ServerPlayer player, String suffix) {
        Path worldFolder = player.m_20194_().m_129843_(LevelResource.f_78178_).getParent();
        String folderName = worldFolder.getFileName().toString();
        String cleanName = folderName.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        String uuid = player.m_20148_().toString().replace("-", "");
        return uuid + "_" + cleanName + "_" + suffix + ".dat";
    }

    public static void saveInvBTD(ServerPlayer player) {
        if (!Variables.clearDreamItems) {
            return;
        }
        CompoundTag root = new CompoundTag();
        ListTag mainList = new ListTag();
        PlayerInvManager.saveInventory(player, root, mainList);
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        File out = new File(saveDir, PlayerInvManager.makeBackupFilename(player, "BTD"));
        try {
            NbtIo.m_128944_((CompoundTag)root, (File)out);
        }
        catch (Exception e) {
            TrueEnd.LOGGER.error("Failed to save BTD for player {}", (Object)player.m_7755_().getString(), (Object)e);
        }
    }

    public static void restoreInvWithChance(ServerPlayer player) {
        if (!Variables.clearDreamItems) {
            return;
        }
        File in = new File(saveDir, PlayerInvManager.makeBackupFilename(player, "BTD"));
        if (!in.exists()) {
            return;
        }
        PlayerInvManager.restoreInventory(player, in, 0.9);
    }

    public static void saveInvNWAD(ServerPlayer player) {
        if (!Variables.clearDreamItems) {
            return;
        }
        CompoundTag root = new CompoundTag();
        ListTag mainList = new ListTag();
        PlayerInvManager.saveInventory(player, root, mainList);
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        File out = new File(saveDir, PlayerInvManager.makeBackupFilename(player, "NWAD"));
        try {
            NbtIo.m_128944_((CompoundTag)root, (File)out);
        }
        catch (Exception e) {
            TrueEnd.LOGGER.error("Failed to save NWAD for player {}", (Object)player.m_7755_().getString(), (Object)e);
        }
    }

    public static void restoreInv(ServerPlayer player) {
        if (!Variables.clearDreamItems) {
            return;
        }
        File in = new File(saveDir, PlayerInvManager.makeBackupFilename(player, "NWAD"));
        if (!in.exists()) {
            return;
        }
        PlayerInvManager.restoreInventory(player, in, 1.0);
    }

    public static void saveInventory(ServerPlayer player, CompoundTag root, ListTag mainList) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag entry = new CompoundTag();
            entry.m_128405_("Slot", i);
            entry.m_128365_("Item", (Tag)stack.m_41739_(new CompoundTag()));
            mainList.add((Object)entry);
        }
        root.m_128365_("Inventory", (Tag)mainList);
        ListTag armorList = new ListTag();
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag entry = new CompoundTag();
            entry.m_128405_("Slot", i);
            entry.m_128365_("Item", (Tag)stack.m_41739_(new CompoundTag()));
            armorList.add((Object)entry);
        }
        root.m_128365_("Armor", (Tag)armorList);
        ListTag offList = new ListTag();
        for (int i = 0; i < player.m_150109_().f_35976_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35976_.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag entry = new CompoundTag();
            entry.m_128405_("Slot", i);
            entry.m_128365_("Item", (Tag)stack.m_41739_(new CompoundTag()));
            offList.add((Object)entry);
        }
        root.m_128365_("Offhand", (Tag)offList);
        if (TrueEnd.inModList("curios")) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInv -> {
                ListTag curiosList = new ListTag();
                Map curios = curiosInv.getCurios();
                curios.forEach((id, stackHandler) -> {
                    if (stackHandler == null) {
                        return;
                    }
                    IDynamicStackHandler stacks = stackHandler.getStacks();
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        ItemStack s = stacks.getStackInSlot(i);
                        if (s.m_41619_()) continue;
                        CompoundTag entry = new CompoundTag();
                        entry.m_128359_("Handler", id);
                        entry.m_128405_("Slot", i);
                        entry.m_128365_("Item", (Tag)s.m_41739_(new CompoundTag()));
                        curiosList.add((Object)entry);
                    }
                });
                root.m_128365_("CuriosInventory", (Tag)curiosList);
            });
        }
        if (TrueEnd.inModList("accessories")) {
            AccessoriesCapability.getOptionally((LivingEntity)player).ifPresent(accessoriesInv -> {
                CompoundTag accList = new CompoundTag();
            });
        }
    }

    public static void restoreInventory(ServerPlayer player, File in, Double chance) {
        try {
            CompoundTag root = NbtIo.m_128937_((File)in);
            ListTag mainList = root.m_128437_("Inventory", 10);
            for (Object t : mainList) {
                CompoundTag entry = (CompoundTag)t;
                int slot = entry.m_128451_("Slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)entry.m_128469_("Item"));
                if (RAND.nextDouble() < chance) {
                    player.m_150109_().m_6836_(slot, stack);
                    continue;
                }
                player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
            }
            ListTag armorList = root.m_128437_("Armor", 10);
            for (Object t : armorList) {
                CompoundTag entry = (CompoundTag)t;
                int slot = entry.m_128451_("Slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)entry.m_128469_("Item"));
                if (RAND.nextDouble() < chance) {
                    player.m_150109_().f_35975_.set(slot, (Object)stack);
                    continue;
                }
                player.m_150109_().f_35975_.set(slot, (Object)ItemStack.f_41583_);
            }
            ListTag offList = root.m_128437_("Offhand", 10);
            for (Tag t : offList) {
                CompoundTag entry = (CompoundTag)t;
                int slot = entry.m_128451_("Slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)entry.m_128469_("Item"));
                if (RAND.nextDouble() < chance) {
                    player.m_150109_().f_35976_.set(slot, (Object)stack);
                    continue;
                }
                player.m_150109_().f_35976_.set(slot, (Object)ItemStack.f_41583_);
            }
            if (root.m_128425_("CuriosInventory", 9) && TrueEnd.inModList("curios")) {
                ListTag curiosList = root.m_128437_("CuriosInventory", 10);
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInv -> {
                    Map curios = curiosInv.getCurios();
                    for (Tag t : curiosList) {
                        CompoundTag entry = (CompoundTag)t;
                        String handlerId = entry.m_128461_("Handler");
                        int slot = entry.m_128451_("Slot");
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)entry.m_128469_("Item"));
                        ICurioStacksHandler handler = (ICurioStacksHandler)curios.get(handlerId);
                        if (handler == null) continue;
                        IDynamicStackHandler stacks = handler.getStacks();
                        if (slot < 0 || slot >= stacks.getSlots()) continue;
                        if (RAND.nextDouble() < chance) {
                            stacks.setStackInSlot(slot, stack);
                            continue;
                        }
                        stacks.setStackInSlot(slot, ItemStack.f_41583_);
                    }
                });
            }
            if (TrueEnd.inModList("accessories")) {
                AccessoriesCapability.getOptionally((LivingEntity)player).ifPresent(accessoriesInv -> {
                    CompoundTag accList = new CompoundTag();
                });
            }
            in.delete();
        }
        catch (Exception e) {
            TrueEnd.LOGGER.error("Failed to restore inventory for player {}", (Object)player.m_7755_().getString(), (Object)e);
        }
    }

    public static void clearAccessories(ServerPlayer player) {
        if (TrueEnd.inModList("curios")) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInv -> {
                Map curios = curiosInv.getCurios();
                curios.forEach((id, stackHandler) -> {
                    if (stackHandler == null) {
                        return;
                    }
                    IDynamicStackHandler stacks = stackHandler.getStacks();
                    int slots = stacks.getSlots();
                    for (int i = 0; i < slots; ++i) {
                        stacks.setStackInSlot(i, ItemStack.f_41583_);
                    }
                });
            });
        }
        if (TrueEnd.inModList("accessories")) {
            AccessoriesCapability.getOptionally((LivingEntity)player).ifPresent(accessoriesInv -> accessoriesInv.reset(false));
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!event.getFrom().equals(Dimensions.BTD) || !event.getTo().equals((Object)Level.f_46428_)) {
            return;
        }
        if (!Variables.clearDreamItems) {
            return;
        }
        player2.getCapability(Variables.PLAYER_VARS_CAP).ifPresent(data -> {
            if (data.hasBeenBeyond()) {
                player2.m_150109_().m_6211_();
                PlayerInvManager.clearAccessories(player2);
                PlayerInvManager.restoreInvWithChance(player2);
                ItemStack cube = new ItemStack((ItemLike)Items.MYSTERIOUS_CUBE.get());
                cube.m_41764_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player2, (ItemStack)cube);
            }
        });
    }
}

