/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures.alphaFeatures;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.mysticcreations.true_end.init.Dimensions;

@Mod.EventBusSubscriber
public class AlphaFoodSystem {
    @SubscribeEvent
    public static int onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        int consumed;
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return 0;
        }
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (player == null) {
            return 0;
        }
        if (player.m_9236_().m_46472_() != Dimensions.BTD) {
            return 0;
        }
        float newHealth = player.m_21223_();
        if (stack.m_41720_() == Items.f_42485_) {
            newHealth += 1.5f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42486_) {
            newHealth += 4.0f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42579_) {
            newHealth += 3.0f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42580_) {
            newHealth += 8.0f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42658_) {
            newHealth += 2.0f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42659_) {
            newHealth += 6.0f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42581_) {
            newHealth += 2.0f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42582_) {
            newHealth += 6.0f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42406_) {
            newHealth += 2.5f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42410_) {
            newHealth += 2.0f;
            consumed = 1;
        } else if (stack.m_41720_() == Items.f_42436_) {
            newHealth += 10.0f;
            consumed = 1;
        } else {
            consumed = stack.m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"true_end:btd_uneatables"))) ? 0 : 2;
        }
        if (consumed == 1) {
            if (!AlphaFoodSystem.healthCheck(event)) {
                stack.m_41774_(1);
                player.m_150109_().m_6596_();
                float maxHealth = player.m_21233_();
                player.m_21153_(Math.min(newHealth, maxHealth));
                AlphaFoodSystem.playEatSound((LevelAccessor)player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
                event.setCanceled(true);
            } else {
                consumed = 0;
            }
        }
        if (consumed == 0 && event.isCancelable()) {
            event.setCanceled(true);
        }
        return consumed;
    }

    @SubscribeEvent
    public static int onRightClickItem(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return 0;
        }
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (player == null) {
            return 0;
        }
        if (player.m_9236_().m_46472_() != Dimensions.BTD) {
            return 0;
        }
        int consumed = stack.m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"true_end:btd_uneatables"))) ? 0 : 2;
        if (consumed == 0 && event.isCancelable()) {
            event.setCanceled(true);
        }
        return consumed;
    }

    private static void playEatSound(LevelAccessor world, double x, double y, double z) {
        double pitch = 0.8 + Math.random() * 0.4;
        if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.m_5776_()) {
                _level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.generic.eat"))), SoundSource.NEUTRAL, 1.0f, (float)pitch);
            } else {
                _level.m_7785_(x, y, z, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.generic.eat"))), SoundSource.NEUTRAL, 1.0f, (float)pitch, false);
            }
        }
    }

    private static boolean healthCheck(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.m_21223_() >= player.m_21233_()) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            return true;
        }
        return false;
    }
}

