/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures.randomEvents;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.network.Variables;

@Mod.EventBusSubscriber
public class TimeChange {
    public static final int DAY = 1000;
    public static final int NOON = 6000;
    public static final int NIGHT = 13000;
    public static final int MIDNIGHT = 18000;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!Variables.randomEventsToggle) {
            return;
        }
        if (!Variables.daytimeChangeToggle) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        long totalDays = serverWorld.m_46468_() / 24000L;
        if (totalDays < 3L) {
            return;
        }
        if (totalDays % 4L != 0L) {
            return;
        }
        TimeChange.makeNight(serverWorld);
        TimeChange.makeDay(serverWorld);
    }

    public static void makeNight(ServerLevel world) {
        if (!(Math.random() < Variables.randomEventChance / 64.0)) {
            return;
        }
        long time = world.m_46468_() % 24000L;
        if (time > 1000L && time < 13000L) {
            long newTime = 13000L + (long)(Math.random() * 5000.0);
            long total = world.m_46468_() - time + newTime;
            world.m_8615_(total);
        }
    }

    public static void makeDay(ServerLevel world) {
        boolean isNight;
        if (!(Math.random() < Variables.randomEventChance / 64.0)) {
            return;
        }
        long time = world.m_46468_() % 24000L;
        boolean bl = isNight = time >= 18000L || time < 1000L;
        if (isNight) {
            long newTime = 1000L + (long)(Math.random() * 5000.0);
            long total = world.m_46468_() - time + newTime;
            world.m_8615_(total);
        }
    }
}

