/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.mysticcreations.true_end.entity.Unknown;
import net.mysticcreations.true_end.init.Blocks;
import net.mysticcreations.true_end.init.Entities;
import net.mysticcreations.true_end.init.Guis;
import net.mysticcreations.true_end.init.Items;
import net.mysticcreations.true_end.init.Packets;
import net.mysticcreations.true_end.init.Particles;
import net.mysticcreations.true_end.init.Sounds;
import net.mysticcreations.true_end.init.Tabs;
import net.mysticcreations.true_end.world.seeping_reality.SeepingForestRegion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import terrablender.api.Region;
import terrablender.api.Regions;

@Mod(value="true_end")
public class TrueEnd {
    public static final Logger LOGGER = LogManager.getLogger(TrueEnd.class);
    public static final String MODID = "true_end";
    public static IEventBus EVENT_BUS;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public TrueEnd(FMLJavaModLoadingContext modContext) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        EVENT_BUS = modContext.getModEventBus();
        Items.REGISTRY.register(EVENT_BUS);
        Blocks.REGISTRY.register(EVENT_BUS);
        Particles.REGISTRY.register(EVENT_BUS);
        Entities.ENTITY_TYPES.register(EVENT_BUS);
        Sounds.REGISTRY.register(EVENT_BUS);
        Guis.REGISTRY.register(EVENT_BUS);
        Tabs.REGISTRY.register(EVENT_BUS);
        EVENT_BUS.addListener(this::commonSetup);
        EVENT_BUS.addListener(this::onEntityAttributeCreation);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Regions.register((Region)new SeepingForestRegion(ResourceLocation.parse((String)"true_end:overworld_region"), 1));
            Packets.register();
        });
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    @SubscribeEvent
    public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)Entities.UNKNOWN.get(), Unknown.createAttributes().m_22265_());
    }

    public static void wait(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    public static void messageWithCooldown(ServerPlayer player, String[] jsonLines, int cooldown) {
        for (int i = 0; i < jsonLines.length; ++i) {
            String rawJson = jsonLines[i];
            TrueEnd.wait(1 + cooldown * i, () -> {
                JsonElement jsonElement = JsonParser.parseString((String)rawJson);
                MutableComponent component = Component.Serializer.m_130691_((JsonElement)jsonElement);
                if (component != null) {
                    player.m_213846_((Component)component);
                }
            });
        }
    }

    public static boolean inModList(String ModID) {
        return ModList.get().isLoaded(ModID);
    }

    public static boolean hasAdvancement(ServerPlayer player, String AdvancementID) {
        return player.m_8960_().m_135996_(player.f_8924_.m_129889_().m_136041_(ResourceLocation.parse((String)AdvancementID))).m_8193_();
    }

    static {
        PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.parse((String)MODID), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }
}

