/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.block;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;
import net.mysticcreations.true_end.init.Dimensions;
import net.mysticcreations.true_end.init.Particles;
import net.mysticcreations.true_end.world.teleporter.BeyondTheDreamPortalShape;
import net.mysticcreations.true_end.world.teleporter.BeyondTheDreamTeleporter;

public class BeyondTheDreamPortal
extends NetherPortalBlock {
    public BeyondTheDreamPortal() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283772_).m_60910_().m_60977_().m_278166_(PushReaction.BLOCK).m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_60953_(s -> 12).m_222994_());
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return false;
    }

    public void m_213898_(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    public static void portalSpawn(Level world, BlockPos pos) {
        Optional<BeyondTheDreamPortalShape> optional = BeyondTheDreamPortalShape.findEmptyPortalShape((LevelAccessor)world, pos, Direction.Axis.X);
        if (optional.isPresent()) {
            optional.get().createPortalBlocks();
            if (!world.m_5776_()) {
                world.m_5594_(null, pos, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"block.beacon.power_select"))), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public BlockState m_7417_(BlockState p_54928_, Direction p_54929_, BlockState p_54930_, LevelAccessor p_54931_, BlockPos p_54932_, BlockPos p_54933_) {
        Direction.Axis direction$axis = p_54929_.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)p_54928_.m_61143_((Property)f_54904_);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && !p_54930_.m_60713_((Block)this) && !new BeyondTheDreamPortalShape(p_54931_, p_54932_, direction$axis1).isComplete() ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_54928_, p_54929_, p_54930_, p_54931_, p_54932_, p_54933_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 4; ++i) {
            double px = (float)pos.m_123341_() + random.m_188501_();
            double py = (float)pos.m_123342_() + random.m_188501_();
            double pz = (float)pos.m_123343_() + random.m_188501_();
            double vx = ((double)random.m_188501_() - 0.5) / 2.0;
            double vy = ((double)random.m_188501_() - 0.5) / 2.0;
            double vz = ((double)random.m_188501_() - 0.5) / 2.0;
            int j = random.m_188503_(4) - 1;
            if (world.m_8055_(pos.m_122024_()).m_60734_() != this && world.m_8055_(pos.m_122029_()).m_60734_() != this) {
                px = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                vx = random.m_188501_() * 2.0f * (float)j;
            } else {
                pz = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                vz = random.m_188501_() * 2.0f * (float)j;
            }
            world.m_7106_((ParticleOptions)Particles.DREAM_PORTAL_PARTICLE.get(), px, py, pz, vx, vy, vz);
        }
        if (random.m_188503_(110) == 0) {
            world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"block.portal.ambient"))), SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.4f + 0.8f);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_6072_() && !entity.m_9236_().m_5776_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else if (entity.m_9236_().m_46472_() != Dimensions.BTD) {
                entity.m_20091_();
                this.teleportToDimension(entity, pos, Dimensions.BTD);
            } else {
                entity.m_20091_();
                this.teleportToDimension(entity, pos, (ResourceKey<Level>)Level.f_46428_);
            }
        }
    }

    private void teleportToDimension(Entity entity, BlockPos pos, ResourceKey<Level> destinationType) {
        entity.changeDimension(Objects.requireNonNull(Objects.requireNonNull(entity.m_20194_()).m_129880_(destinationType)), (ITeleporter)new BeyondTheDreamTeleporter(entity.m_20194_().m_129880_(destinationType), pos));
    }
}

