/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.mysticcreations.true_end.init.Blocks;

public class GrassBlock
extends Block {
    public GrassBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283916_).m_60918_(SoundType.f_56740_).m_60978_(0.6f).m_60977_());
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!GrassBlock.canStayGrass((LevelReader)world, pos) && !world.m_5776_()) {
            world.m_7731_(pos, ((Block)Blocks.DIRT.get()).m_49966_(), 3);
        }
    }

    private static boolean canStayGrass(LevelReader world, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = world.m_8055_(abovePos);
        if (aboveState.m_60713_((Block)Blocks.LEAVES.get())) {
            return true;
        }
        return aboveState.m_60739_((BlockGetter)world, abovePos) <= 0;
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        float pitch = 0.9f + world.m_213780_().m_188501_() * 0.2f;
        if (player.m_21205_().m_204117_(ItemTags.f_271298_)) {
            world.m_7731_(BlockPos.m_274561_((double)x, (double)y, (double)z), ((Block)Blocks.FARMLAND.get()).m_49966_(), 3);
            world.m_6263_(null, (double)x, (double)y, (double)z, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, pitch);
            player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            GrassBlock.getSeeds((LevelAccessor)world, x, y, z, (Entity)player, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static void getSeeds(LevelAccessor world, double x, double y, double z, Entity entity, Player player) {
        if (entity == null) {
            return;
        }
        if (!player.m_21205_().m_204117_(ItemTags.f_271298_)) {
            return;
        }
        if (!(Math.random() < 0.125)) {
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            ItemEntity seedsItem = new ItemEntity((Level)level, x, y + 1.1, z, new ItemStack((ItemLike)Items.f_42404_));
            seedsItem.m_32010_(15);
            level.m_7967_((Entity)seedsItem);
        }
    }
}

