/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.client;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.mysticcreations.true_end.TrueEnd;
import net.mysticcreations.true_end.entity.renderer.UnknownEntityRenderer;
import net.mysticcreations.true_end.init.Blocks;
import net.mysticcreations.true_end.init.Items;

@Mod.EventBusSubscriber(modid="true_end", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        TrueEnd.EVENT_BUS.addListener(UnknownEntityRenderer::registerEntityRenderers);
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)Items.DREAMERS_COMPASS.get()), (ResourceLocation)ResourceLocation.parse((String)"angle"), (stack, world, entity, seed) -> {
                if (world == null || entity == null) {
                    return 0.0f;
                }
                CompoundTag tag = stack.m_41784_();
                if (!tag.m_128471_("TargetTracked")) {
                    return 0.0f;
                }
                BlockPos targetPos = new BlockPos(tag.m_128451_("TargetX"), tag.m_128451_("TargetY"), tag.m_128451_("TargetZ"));
                BlockPos playerPos = entity.m_20183_();
                float playerYaw = entity.m_146908_();
                double dx = targetPos.m_123341_() - playerPos.m_123341_();
                double dz = targetPos.m_123343_() - playerPos.m_123343_();
                double targetAngle = Math.toDegrees(Math.atan2(dz, dx));
                targetAngle = (targetAngle - 90.0) % 360.0;
                targetAngle = (targetAngle + 360.0) % 360.0;
                playerYaw = (playerYaw + 360.0f) % 360.0f;
                double relative = (targetAngle - (double)playerYaw + 360.0) % 360.0;
                float angleValue = (float)(relative / 360.0);
                return angleValue;
            });
            ItemProperties.register((Item)((Block)Blocks.VOID.get()).m_5456_(), (ResourceLocation)ResourceLocation.parse((String)"true_end:type"), (stack, world, entity, seed) -> {
                CompoundTag bst = stack.m_41737_("BlockStateTag");
                if (bst != null && "white".equals(bst.m_128461_("type"))) {
                    return 1.0f;
                }
                return 0.0f;
            });
        });
    }
}

