/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.client.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.init.Dimensions;

@Mod.EventBusSubscriber(modid="true_end", value={Dist.CLIENT})
public class VersionOverlay {
    private static final String BASE_TEXT = "Minecraft Alpha v1.1.2_10";
    private static final String[] VERSIONS = new String[]{"Minecraft Alpha v1.1.2", "Minecraft Alpha v1.1.2_01", "Minecraft v1.20.1", "Minecraft Snapshot -3w21a", "Minecraft Beta v1.0.46", "Minecraft Alpha v1.0.7", "Minecraft Alpha v1.0.16_02"};
    private static String currentText = "Minecraft Alpha v1.1.2_10";
    private static int flashTicks = 4;
    private static final Random random = new Random();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91073_.m_46472_() != Dimensions.BTD) {
            currentText = BASE_TEXT;
            flashTicks = 0;
            return;
        }
        if (flashTicks > 0) {
            if (--flashTicks == 0) {
                currentText = BASE_TEXT;
            }
        } else if (random.nextInt(6000) == 0) {
            currentText = VERSIONS[random.nextInt(VERSIONS.length)];
            flashTicks = 2 + random.nextInt(5);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91073_.m_46472_() != Dimensions.BTD) {
            return;
        }
        if (mc.f_91066_.f_92063_) {
            return;
        }
        GuiGraphics gui = event.getGuiGraphics();
        PoseStack pose = gui.m_280168_();
        int fontSize = 32;
        float guiScaleFactor = (float)mc.m_91268_().m_85443_() / (float)mc.m_91268_().m_85445_();
        Objects.requireNonNull(mc.f_91062_);
        float baseFontHeight = 9.0f;
        float userScale = 32.0f / baseFontHeight;
        pose.m_85836_();
        pose.m_85841_(1.0f / guiScaleFactor, 1.0f / guiScaleFactor, 1.0f);
        pose.m_85841_(userScale, userScale, 1.0f);
        int x = 6;
        int y = 6;
        int textColor = 0xFFFFFF;
        int textShadowColor = -12632257;
        int drawX = Math.round((float)x / userScale);
        int drawY = Math.round((float)y / userScale);
        gui.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)currentText), drawX + 1, drawY + 1, textShadowColor, false);
        gui.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)currentText), drawX, drawY, textColor, false);
        pose.m_85849_();
    }
}

