/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.mysticcreations.true_end.TrueEnd;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Variables {
    public static final Capability<PlayerVariables> PLAYER_VARS_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});
    public static final Capability<MapVariables> MAP_VARIABLES_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<MapVariables>(){});
    public static double randomEventChance;
    public static double entitySpawnChance;
    public static boolean popupsToggle;
    public static boolean fogToggle;
    public static boolean creditsToggle;
    public static int btdConversationDelay;
    public static boolean randomEventsToggle;
    public static boolean flashingLights;
    public static boolean daytimeChangeToggle;
    public static boolean clearDreamItems;
    public static boolean fogToggleClient;

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent evt) {
        TrueEnd.PACKET_HANDLER.registerMessage(0, MapVariablesSyncMessage.class, MapVariablesSyncMessage::encode, MapVariablesSyncMessage::decode, MapVariablesSyncMessage::handle);
        TrueEnd.PACKET_HANDLER.registerMessage(1, PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::encode, PlayerVariablesSyncMessage::decode, PlayerVariablesSyncMessage::handle);
    }

    @SubscribeEvent
    public static void onRegisterCaps(RegisterCapabilitiesEvent evt) {
        evt.register(PlayerVariables.class);
        evt.register(MapVariables.class);
    }

    public static class MapVariablesSyncMessage {
        private final CompoundTag data;

        public MapVariablesSyncMessage(MapVariables vars) {
            this.data = vars.m_7176_(new CompoundTag());
        }

        public static void encode(MapVariablesSyncMessage msg, FriendlyByteBuf buf) {
            buf.m_130079_(msg.data);
        }

        public static MapVariablesSyncMessage decode(FriendlyByteBuf buf) {
            return new MapVariablesSyncMessage(MapVariables.load(buf.m_130260_()));
        }

        public static void handle(MapVariablesSyncMessage msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                MapVariables client = MapVariables.get((LevelAccessor)Minecraft.m_91087_().f_91073_);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final CompoundTag data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buf) {
            this.data = buf.m_130260_();
        }

        public PlayerVariablesSyncMessage(PlayerVariables vars) {
            this.data = vars.writeNBT();
        }

        public static void encode(PlayerVariablesSyncMessage msg, FriendlyByteBuf buf) {
            buf.m_130079_(msg.data);
        }

        public static PlayerVariablesSyncMessage decode(FriendlyByteBuf buf) {
            return new PlayerVariablesSyncMessage(buf);
        }

        public static void handle(PlayerVariablesSyncMessage msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARS_CAP).ifPresent(v -> v.readNBT(msg.data)));
            ctx.get().setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        private boolean beenBeyond = false;
        private int seepingRealityTime = 0;

        public boolean hasBeenBeyond() {
            return this.beenBeyond;
        }

        public void setBeenBeyond(boolean v) {
            this.beenBeyond = v;
        }

        public int getSeepingRealityTime() {
            return this.seepingRealityTime;
        }

        public void setSeepingRealityTime(int v) {
            this.seepingRealityTime = v;
        }

        public void sync(ServerPlayer player) {
            TrueEnd.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PlayerVariablesSyncMessage(this));
        }

        public CompoundTag writeNBT() {
            CompoundTag n = new CompoundTag();
            n.m_128379_("beenBeyond", this.beenBeyond);
            n.m_128405_("seepingRealityTime", this.seepingRealityTime);
            return n;
        }

        public void readNBT(CompoundTag n) {
            this.beenBeyond = n.m_128471_("beenBeyond");
            this.seepingRealityTime = n.m_128451_("seepingRealityTime");
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "true_end_mapvars";
        private double btdSpawnX = 0.0;
        private double btdSpawnY = 0.0;
        private double btdSpawnZ = 0.0;
        private boolean unknownInWorld = false;
        private int btdConversationDelay = 0;
        private double randomEventChance = 0.0;
        private boolean randomEventsToggle = false;
        private boolean flashingLights = false;
        private boolean daytimeChangeToggle = false;
        private boolean clearDreamItems = false;

        public boolean isUnknownInWorld() {
            return this.unknownInWorld;
        }

        public double getBtdSpawnX() {
            return this.btdSpawnX;
        }

        public double getBtdSpawnY() {
            return this.btdSpawnY;
        }

        public double getBtdSpawnZ() {
            return this.btdSpawnZ;
        }

        public void setUnknownInWorld(boolean v) {
            this.unknownInWorld = v;
            this.m_77762_();
        }

        public void setBtdSpawn(double x, double y, double z) {
            this.btdSpawnX = x;
            this.btdSpawnY = y;
            this.btdSpawnZ = z;
            this.m_77762_();
        }

        public static MapVariables load(CompoundTag nbt) {
            MapVariables m = new MapVariables();
            m.btdSpawnX = nbt.m_128459_("btdSpawnX");
            m.btdSpawnY = nbt.m_128459_("btdSpawnY");
            m.btdSpawnZ = nbt.m_128459_("btdSpawnZ");
            m.unknownInWorld = nbt.m_128471_("unknownInWorld");
            m.btdConversationDelay = nbt.m_128451_("btdConversationDelay");
            m.randomEventChance = nbt.m_128459_("randomEventChance");
            m.randomEventsToggle = nbt.m_128471_("randomEventsToggle");
            m.flashingLights = nbt.m_128471_("flashingLights");
            m.daytimeChangeToggle = nbt.m_128471_("daytimeChangeToggle");
            m.clearDreamItems = nbt.m_128471_("clearDreamItems");
            return m;
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("btdSpawnX", this.btdSpawnX);
            nbt.m_128347_("btdSpawnY", this.btdSpawnY);
            nbt.m_128347_("btdSpawnZ", this.btdSpawnZ);
            nbt.m_128379_("unknownInWorld", this.unknownInWorld);
            nbt.m_128405_("btdConversationDelay", this.btdConversationDelay);
            nbt.m_128347_("randomEventChance", this.randomEventChance);
            nbt.m_128379_("randomEventsToggle", this.randomEventsToggle);
            nbt.m_128379_("flashingLights", this.flashingLights);
            nbt.m_128379_("daytimeChangeToggle", this.daytimeChangeToggle);
            nbt.m_128379_("clearDreamItems", this.clearDreamItems);
            return nbt;
        }

        public static MapVariables get(LevelAccessor world) {
            if (!(world instanceof ServerLevel)) {
                return new MapVariables();
            }
            ServerLevel lvl = (ServerLevel)world;
            ServerLevel overworld = lvl.m_7654_().m_129880_(Level.f_46428_);
            return (MapVariables)overworld.m_8895_().m_164861_(MapVariables::load, MapVariables::new, DATA_NAME);
        }

        public void syncAll(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)world;
                TrueEnd.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new MapVariablesSyncMessage(this));
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class PlayerVariablesProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerVariables vars = new PlayerVariables();
        private final LazyOptional<PlayerVariables> opt = LazyOptional.of(() -> this.vars);

        @SubscribeEvent
        public static void attachCaps(AttachCapabilitiesEvent<Entity> evt) {
            if (evt.getObject() instanceof Player && evt.getObject() instanceof ServerPlayer) {
                evt.addCapability(ResourceLocation.parse((String)"true_end:player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        @SubscribeEvent
        public static void cloneOnDeath(PlayerEvent.Clone evt) {
            if (!evt.isWasDeath()) {
                return;
            }
            evt.getOriginal().reviveCaps();
            evt.getOriginal().getCapability(PLAYER_VARS_CAP).ifPresent(oldV -> evt.getEntity().getCapability(PLAYER_VARS_CAP).ifPresent(newV -> {
                newV.setBeenBeyond(oldV.hasBeenBeyond());
                newV.setSeepingRealityTime(oldV.getSeepingRealityTime());
            }));
        }

        @SubscribeEvent
        public static void syncOnLogin(PlayerEvent.PlayerLoggedInEvent evt) {
            evt.getEntity().getCapability(PLAYER_VARS_CAP).ifPresent(v -> v.sync((ServerPlayer)evt.getEntity()));
        }

        @SubscribeEvent
        public static void syncOnRespawn(PlayerEvent.PlayerRespawnEvent evt) {
            evt.getEntity().getCapability(PLAYER_VARS_CAP).ifPresent(v -> v.sync((ServerPlayer)evt.getEntity()));
        }

        @SubscribeEvent
        public static void syncOnDimChange(PlayerEvent.PlayerChangedDimensionEvent evt) {
            evt.getEntity().getCapability(PLAYER_VARS_CAP).ifPresent(v -> v.sync((ServerPlayer)evt.getEntity()));
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARS_CAP ? this.opt.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.vars.writeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.vars.readNBT(nbt);
        }
    }
}

