/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures;

import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.TrueEnd;
import net.mysticcreations.true_end.init.Blocks;
import net.mysticcreations.true_end.init.Dimensions;
import net.mysticcreations.true_end.network.Variables;
import net.mysticcreations.true_end.procedures.PlayerInvManager;

@Mod.EventBusSubscriber
public class DimSwapToBTD {
    private static final Map<ServerPlayer, Boolean> HAS_PROCESSED = new HashMap<ServerPlayer, Boolean>();
    public static final int HOUSE_PLATEAU_WIDTH = 9;
    public static final int HOUSE_PLATEAU_LENGTH = 7;
    public static final int TERRAIN_ADAPT_EXTENSION = 10;
    public static final int MAX_FALLBACK_SEARCH_TRIES = 48;
    public static final BlockPos ABSOLUTE_FALLBACK_POS = new BlockPos(0, 120, 12550832);
    public static final int BlockPosRandomX = 16 + (int)(Math.random() * 33.0);
    public static final int BlockPosRandomY = 128 + (int)(Math.random() * 129.0);
    public static final int BlockPosRandomZ = 16 + (int)(Math.random() * 33.0);

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        if (event.getAdvancement().m_138327_().equals((Object)ResourceLocation.parse((String)"true_end:stop_dreaming"))) {
            Level level;
            Player entity = event.getEntity();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)entity;
            if (HAS_PROCESSED.getOrDefault(player, false).booleanValue()) {
                return;
            }
            AtomicBoolean hasVisited = new AtomicBoolean(false);
            player.getCapability(Variables.PLAYER_VARS_CAP).ifPresent(data -> hasVisited.set(data.hasBeenBeyond()));
            if (!hasVisited.get() && player.m_9236_().m_46472_() == Level.f_46428_ && (level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel overworld = (ServerLevel)level;
                if (player.m_8960_().m_135996_(Objects.requireNonNull(player.f_8924_.m_129889_().m_136041_(ResourceLocation.parse((String)"true_end:stop_dreaming")))).m_8193_()) {
                    HAS_PROCESSED.put(player, true);
                    ServerLevel nextLevel = player.f_8924_.m_129880_(Dimensions.BTD);
                    if (nextLevel == null || player.m_9236_().m_46472_() == Dimensions.BTD) {
                        HAS_PROCESSED.remove(player);
                        return;
                    }
                    player.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, 0.0f));
                    Variables.MapVariables getVariable = Variables.MapVariables.get((LevelAccessor)nextLevel);
                    double btdSpawnX = getVariable.getBtdSpawnX();
                    double btdSpawnY = getVariable.getBtdSpawnY();
                    double btdSpawnZ = getVariable.getBtdSpawnZ();
                    if (btdSpawnY > 0.0) {
                        player.m_8999_(nextLevel, btdSpawnX, btdSpawnY, btdSpawnZ, 0.0f, 0.0f);
                        player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
                        for (MobEffectInstance effect : player.m_21220_()) {
                            player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), effect));
                        }
                        DimSwapToBTD.sendFirstEntryConversation(player);
                        DimSwapToBTD.executeCommand((LevelAccessor)nextLevel, (Entity)player, "function true_end:spawn/global_spawn");
                        player.getCapability(Variables.PLAYER_VARS_CAP).ifPresent(data -> data.setBeenBeyond(true));
                        HAS_PROCESSED.remove(player);
                        if (Variables.clearDreamItems) {
                            PlayerInvManager.saveInvBTD(player);
                            PlayerInvManager.clearAccessories(player);
                            player.m_150109_().m_6211_();
                        }
                        return;
                    }
                    TrueEnd.wait(4, () -> {
                        boolean absoluteFallbackPlatform;
                        boolean adaptTerrain;
                        BlockPos worldSpawn = overworld.m_220360_();
                        BlockPos initialSearchPos = DimSwapToBTD.locateBiome(nextLevel, worldSpawn, "true_end:plains");
                        if (initialSearchPos == null) {
                            initialSearchPos = worldSpawn;
                        }
                        BlockPos spawnPos = DimSwapToBTD.findSpawn(nextLevel, initialSearchPos);
                        BlockPos secondarySearchPos = DimSwapToBTD.locateBiome(nextLevel, new BlockPos(new Vec3i(BlockPosRandomX, BlockPosRandomY, BlockPosRandomZ)), "true_end:plains");
                        if (spawnPos == null) {
                            for (int i = 0; i <= 48 && (spawnPos = DimSwapToBTD.fallbackSpawn(nextLevel, secondarySearchPos = new BlockPos(new Vec3i(BlockPosRandomX + BlockPosRandomZ, BlockPosRandomY, BlockPosRandomZ + BlockPosRandomX)))) == null; ++i) {
                            }
                        }
                        if (spawnPos == null) {
                            adaptTerrain = false;
                            absoluteFallbackPlatform = true;
                            spawnPos = ABSOLUTE_FALLBACK_POS;
                        } else {
                            adaptTerrain = true;
                            absoluteFallbackPlatform = false;
                        }
                        BlockPos finalSpawnPos = spawnPos;
                        BlockPos secFinalSpawnPos = secondarySearchPos;
                        player.m_8999_(nextLevel, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                        player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
                        for (MobEffectInstance effect : player.m_21220_()) {
                            player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), effect));
                        }
                        TrueEnd.wait(4, () -> {
                            if (absoluteFallbackPlatform) {
                                DimSwapToBTD.executeCommand((LevelAccessor)nextLevel, (Entity)player, "function true_end:spawn/farlands_spawn");
                            }
                            if (adaptTerrain) {
                                DimSwapToBTD.adaptTerrain(nextLevel, player.m_20183_());
                            }
                            DimSwapToBTD.removeNearbyTrees(nextLevel, player.m_20183_(), 15);
                            DimSwapToBTD.executeCommand((LevelAccessor)nextLevel, (Entity)player, "function true_end:home/build_home");
                            DimSwapToBTD.setGlobalSpawn((LevelAccessor)nextLevel, player);
                            DimSwapToBTD.sendFirstEntryConversation(player);
                            player.getCapability(Variables.PLAYER_VARS_CAP).ifPresent(data -> data.setBeenBeyond(true));
                            if (secFinalSpawnPos == null) {
                                nextLevel.getCapability(Variables.MAP_VARIABLES_CAP).ifPresent(data -> data.setBtdSpawn(finalSpawnPos.m_123341_(), finalSpawnPos.m_123342_() - 1, finalSpawnPos.m_123343_()));
                            } else {
                                nextLevel.getCapability(Variables.MAP_VARIABLES_CAP).ifPresent(data -> data.setBtdSpawn(secFinalSpawnPos.m_123341_(), secFinalSpawnPos.m_123342_() - 1, secFinalSpawnPos.m_123343_()));
                            }
                            HAS_PROCESSED.remove(player);
                        });
                        if (Variables.clearDreamItems) {
                            PlayerInvManager.saveInvBTD(player);
                            PlayerInvManager.clearAccessories(player);
                            player.m_150109_().m_6211_();
                        }
                    });
                }
            }
        }
    }

    public static BlockPos findSpawn(ServerLevel level, BlockPos centerPos) {
        int searchRadius = 24;
        for (int y = 75; y >= 64; --y) {
            for (int x = -searchRadius; x <= searchRadius; ++x) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos candidate = centerPos.m_7918_(x, y - centerPos.m_123342_(), z);
                    BlockPos above = candidate.m_7494_();
                    BlockPos above2 = above.m_7494_();
                    if (!level.m_8055_(candidate).m_60713_((Block)Blocks.GRASS_BLOCK.get()) || !level.m_204166_(candidate).m_203373_(ResourceLocation.parse((String)"true_end:plains")) || !DimSwapToBTD.notOnAfuckingHill(level, candidate) || !DimSwapToBTD.isYInSpawnRange(level, candidate) || !DimSwapToBTD.noBadBlocks(level, candidate) || !level.m_46859_(above) || !level.m_46859_(above2) || level.m_45517_(LightLayer.SKY, above) < 15 || !DimSwapToBTD.isValidSpawnArea(level, candidate)) continue;
                    TrueEnd.LOGGER.info("Found ideal spawn: {}", (Object)above);
                    return above;
                }
            }
        }
        return null;
    }

    public static BlockPos fallbackSpawn(ServerLevel level, BlockPos centerPos) {
        int searchRadius = 32;
        for (int y = level.m_151558_() - 16; y >= level.m_141937_() + 8; --y) {
            for (int x = -searchRadius; x <= searchRadius; ++x) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos candidate = centerPos.m_7918_(x, y - centerPos.m_123342_(), z);
                    BlockPos above = candidate.m_7494_();
                    if (!level.m_8055_(candidate).m_60713_((Block)Blocks.GRASS_BLOCK.get()) || !level.m_204166_(candidate).m_203373_(ResourceLocation.parse((String)"true_end:plains")) || !DimSwapToBTD.notOnAfuckingHill(level, candidate) || !DimSwapToBTD.isYInSpawnRange(level, candidate) || !DimSwapToBTD.noBadBlocks(level, candidate) || !level.m_46859_(above) || !DimSwapToBTD.isValidSpawnArea(level, candidate)) continue;
                    TrueEnd.LOGGER.info("Found fallback spawn: {}", (Object)above);
                    return above;
                }
            }
        }
        return null;
    }

    public static void setGlobalSpawn(LevelAccessor world, ServerPlayer player) {
        Variables.MapVariables.get(world).setBtdSpawn(player.m_20185_(), player.m_20186_(), player.m_20189_());
    }

    private static Predicate<Holder<Biome>> isBiome(String biomeNamespaced) {
        return biomeHolder -> biomeHolder.m_203543_().map(biomeKey -> biomeKey.m_135782_().toString().equals(biomeNamespaced)).orElse(false);
    }

    public static BlockPos locateBiome(ServerLevel level, BlockPos startPosition, String biomeNamespaced) {
        Pair result = level.m_6018_().m_215069_(DimSwapToBTD.isBiome(biomeNamespaced), startPosition, 6400, 32, 64);
        if (result == null) {
            return null;
        }
        return (BlockPos)result.getFirst();
    }

    public static void adaptTerrain(ServerLevel world, BlockPos centerPos) {
        BlockPos placePos = new BlockPos(centerPos.m_123341_() - 4, centerPos.m_123342_() - 1, centerPos.m_123343_() - 3);
        int plateauHeight = placePos.m_123342_();
        for (int x = 0; x < 9; ++x) {
            for (int z = 0; z < 7; ++z) {
                BlockPos grassPos = new BlockPos(x + placePos.m_123341_(), plateauHeight, z + placePos.m_123343_());
                BlockState existing = world.m_8055_(grassPos);
                if (!existing.m_60795_() && !existing.m_60819_().m_205070_(FluidTags.f_13131_) && !existing.m_60819_().m_205070_(FluidTags.f_13132_) && !existing.m_60713_((Block)Blocks.GRASS_BLOCK.get()) && !existing.m_60713_((Block)Blocks.SAND.get()) && !existing.m_60713_((Block)Blocks.FLOWER.get()) && !existing.m_60713_((Block)Blocks.ROSE.get())) continue;
                DimSwapToBTD.placeGrassWithDirt(world, grassPos);
            }
        }
        int radius = 10;
        int centerX = placePos.m_123341_() + 4;
        int centerZ = placePos.m_123343_() + 3;
        int maxDist = radius + Math.max(9, 7) / 2;
        for (int dx = -maxDist; dx <= maxDist; ++dx) {
            for (int dz = -maxDist; dz <= maxDist; ++dz) {
                boolean insidePlateau;
                double distFromCenter = Math.sqrt(dx * dx + dz * dz);
                if (distFromCenter > (double)radius + (double)Math.max(9, 7) / 2.0) continue;
                int worldX = centerX + dx;
                int worldZ = centerZ + dz;
                int localX = worldX - placePos.m_123341_();
                int localZ = worldZ - placePos.m_123343_();
                boolean bl = insidePlateau = localX >= 0 && localX < 9 && localZ >= 0 && localZ < 7;
                if (insidePlateau) continue;
                BlockPos checkPos = new BlockPos(worldX, plateauHeight, worldZ);
                int targetHeight = DimSwapToBTD.getLocalMax(world, checkPos);
                int dist = (int)Math.round(distFromCenter) - Math.max(9, 7) / 2;
                if (dist < 0 || dist > radius) continue;
                int height = DimSwapToBTD.gradient(targetHeight, plateauHeight, radius, dist);
                height = Math.max(world.m_141937_(), Math.min(height, world.m_151558_() - 1));
                BlockPos grassPos = new BlockPos(worldX, height, worldZ);
                BlockState existing = world.m_8055_(grassPos);
                if (!existing.m_60795_() && !existing.m_60819_().m_205070_(FluidTags.f_13131_) && !existing.m_60819_().m_205070_(FluidTags.f_13132_) && !existing.m_60713_((Block)Blocks.GRASS_BLOCK.get()) && !existing.m_60713_((Block)Blocks.SAND.get()) && !existing.m_60713_((Block)Blocks.FLOWER.get()) && !existing.m_60713_((Block)Blocks.ROSE.get())) continue;
                DimSwapToBTD.placeGrassWithDirt(world, grassPos);
            }
        }
    }

    private static void placeGrassWithDirt(ServerLevel world, BlockPos pos) {
        int y = Math.max(world.m_141937_(), Math.min(pos.m_123342_(), world.m_151558_() - 1));
        BlockPos clampedPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
        BlockState existing = world.m_8055_(clampedPos);
        if (!(existing.m_60795_() || existing.m_60819_().m_205070_(FluidTags.f_13131_) || existing.m_60819_().m_205070_(FluidTags.f_13132_) || existing.m_60713_((Block)Blocks.GRASS_BLOCK.get()) || existing.m_60713_((Block)Blocks.SAND.get()) || existing.m_60713_((Block)Blocks.FLOWER.get()) || existing.m_60713_((Block)Blocks.ROSE.get()))) {
            return;
        }
        world.m_7731_(clampedPos, ((Block)Blocks.GRASS_BLOCK.get()).m_49966_(), 3);
        BlockPos.MutableBlockPos mutablePos = clampedPos.m_122032_();
        for (int yy = clampedPos.m_123342_() - 1; yy >= world.m_141937_(); --yy) {
            mutablePos.m_142448_(yy);
            BlockState current = world.m_8055_((BlockPos)mutablePos);
            if (!current.m_60795_() && !current.m_60819_().m_205070_(FluidTags.f_13131_) && !current.m_60819_().m_205070_(FluidTags.f_13132_) && !current.m_60713_((Block)Blocks.GRASS_BLOCK.get()) && !current.m_60713_((Block)Blocks.DIRT.get()) && !current.m_60713_((Block)Blocks.SAND.get()) && !current.m_60713_((Block)Blocks.FLOWER.get()) && !current.m_60713_((Block)Blocks.ROSE.get())) break;
            world.m_7731_((BlockPos)mutablePos, ((Block)Blocks.DIRT.get()).m_49966_(), 3);
        }
    }

    private static int gradient(int targetHeight, int centerHeight, int maxDist, int dist) {
        float t = (float)dist / (float)maxDist;
        return Math.round((float)centerHeight * (1.0f - t) + (float)targetHeight * t);
    }

    public static int getLocalMax(ServerLevel world, BlockPos pos) {
        int maxY;
        int max = maxY = world.m_151558_() - 1;
        for (int y = maxY; y >= 0; --y) {
            BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (world.m_8055_(checkPos).m_60734_() == net.minecraft.world.level.block.Blocks.f_50016_ || world.m_8055_(checkPos).m_60734_() == Blocks.WOOD.get() || world.m_8055_(checkPos).m_60734_() == Blocks.LEAVES.get()) continue;
            if (y < pos.m_123342_()) {
                return y - 1;
            }
            max = y - 1;
        }
        return max;
    }

    private static boolean isValidSpawnArea(ServerLevel level, BlockPos center) {
        int MAX_TERRAIN_DROP = 7;
        int MAX_TERRAIN_ASCENT = 3;
        int centerY = DimSwapToBTD.getLocalMax(level, new BlockPos(center.m_123341_(), level.m_151558_() - 1, center.m_123343_()));
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                BlockPos pos = new BlockPos(center.m_123341_() + dx, level.m_151558_() - 1, center.m_123343_() + dz);
                int terrainY = DimSwapToBTD.getLocalMax(level, pos);
                int deltaY = terrainY - centerY;
                if (deltaY <= MAX_TERRAIN_ASCENT && -deltaY <= MAX_TERRAIN_DROP) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean noBadBlocks(ServerLevel level, BlockPos center) {
        int R = 3;
        int cx = center.m_123341_();
        int cy = center.m_123342_();
        int cz = center.m_123343_();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                BlockPos atFeet = new BlockPos(cx + dx, cy, cz + dz);
                BlockPos below = new BlockPos(cx + dx, cy - 1, cz + dz);
                BlockPos below2 = below.m_7495_();
                BlockState stateAtFeet = level.m_8055_(atFeet);
                BlockState stateBelow = level.m_8055_(below);
                BlockState stateBelow2 = level.m_8055_(below2);
                if (!stateAtFeet.m_60713_(net.minecraft.world.level.block.Blocks.f_49990_) && !stateBelow.m_60713_(net.minecraft.world.level.block.Blocks.f_49990_) && !stateBelow2.m_60713_(net.minecraft.world.level.block.Blocks.f_49990_) && !stateAtFeet.m_60713_((Block)Blocks.SAND.get()) && !stateBelow.m_60713_((Block)Blocks.SAND.get()) && !stateBelow2.m_60713_((Block)Blocks.SAND.get())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean notOnAfuckingHill(ServerLevel level, BlockPos center) {
        int STEEPNESS_LIMIT = 2;
        int centerGroundY = DimSwapToBTD.getLocalMax(level, new BlockPos(center.m_123341_(), level.m_151558_() - 1, center.m_123343_()));
        for (int dx = -6; dx <= 6; ++dx) {
            for (int dz = -6; dz <= 6; ++dz) {
                BlockPos neighborColumn;
                int neighborGroundY;
                if (dx == 0 && dz == 0 || Math.abs((neighborGroundY = DimSwapToBTD.getLocalMax(level, neighborColumn = new BlockPos(center.m_123341_() + dx, level.m_151558_() - 1, center.m_123343_() + dz))) - centerGroundY) <= 2) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isYInSpawnRange(ServerLevel level, BlockPos pos) {
        int y = pos.m_123342_();
        return y >= 66 && y <= 80;
    }

    private static boolean isTreeBlock(Block block) {
        return block.m_49966_().m_204336_(BlockTags.f_13035_) || block.m_49966_().m_204336_(BlockTags.f_13106_);
    }

    public static void removeNearbyTrees(ServerLevel level, BlockPos center, int radius) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    BlockState state = level.m_8055_((BlockPos)mutablePos);
                    Block block = state.m_60734_();
                    if (!DimSwapToBTD.isTreeBlock(block)) continue;
                    BlockPos foundPos = mutablePos.m_7949_();
                    level.m_7471_(foundPos, true);
                    queue.add(foundPos);
                    visited.add(foundPos);
                }
            }
        }
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            for (Direction direction : Direction.values()) {
                BlockState neighborState;
                Block neighborBlock;
                BlockPos neighbor = current.m_121945_(direction);
                if (visited.contains(neighbor) || !DimSwapToBTD.isTreeBlock(neighborBlock = (neighborState = level.m_8055_(neighbor)).m_60734_())) continue;
                level.m_7471_(neighbor, true);
                queue.add(neighbor);
                visited.add(neighbor);
            }
        }
    }

    private static void executeCommand(LevelAccessor world, Entity entity, String command) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                level.m_7654_().m_129892_().m_230957_(player.m_20203_().m_81324_(), command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendFirstEntryConversation(ServerPlayer player) {
        ArrayList<CallSite> jsonLines = new ArrayList<CallSite>();
        InputStream file = DimSwapToBTD.class.getClassLoader().getResourceAsStream("assets/true_end/texts/first_entry.txt");
        assert (file != null);
        BufferedReader br = new BufferedReader(new InputStreamReader(file, StandardCharsets.UTF_8));
        try {
            String line1;
            while ((line1 = br.readLine()) != null) {
                String raw1 = line1.replace("PLAYERNAME", player.m_7755_().getString());
                String line2 = br.readLine();
                String raw2 = line2 != null ? line2.replace("PLAYERNAME", player.m_7755_().getString()) : "";
                String combined = raw1 + (String)(raw2.isEmpty() ? "" : "\n" + raw2);
                String escaped = combined.replace("\"", "\\\"");
                String json = "{\"text\":\"" + escaped + "\"}";
                jsonLines.add((CallSite)((Object)json));
            }
        }
        catch (Exception e) {
            TrueEnd.LOGGER.error("Error reading {} with exception {}", (Object)file, (Object)e);
            return;
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        TrueEnd.wait(45, () -> TrueEnd.messageWithCooldown(player, jsonLines.toArray(new String[0]), Variables.btdConversationDelay));
    }
}

