/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.TrueEnd;
import net.mysticcreations.true_end.init.Dimensions;
import net.mysticcreations.true_end.network.Variables;
import net.mysticcreations.true_end.procedures.PlayerInvManager;

@Mod.EventBusSubscriber
public class DimSwapToNWAD {
    private static final Map<UUID, ResourceKey<Level>> diedIn = new HashMap<UUID, ResourceKey<Level>>();

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_9236_();
        DamageSource source = event.getSource();
        if (entity.m_9236_().m_46472_() == Dimensions.BTD || entity.m_9236_().m_46472_() == Dimensions.NWAD) {
            return;
        }
        if (source == null) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!source.m_276093_(DamageTypes.f_268612_) || !source.m_276093_(DamageTypes.f_268724_)) {
            return;
        }
        if (Math.random() < Variables.randomEventChance * 2.0) {
            return;
        }
        if (TrueEnd.hasAdvancement(player, "true_end:leave_the_nightmare_within_a_dream")) {
            return;
        }
        PlayerInvManager.saveInvNWAD(player);
        if (!world.m_5776_()) {
            player.m_143403_(GameType.ADVENTURE);
            DimSwapToNWAD.teleportToNWAD(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ResourceKey dim = player.m_9236_().m_46472_();
        if (dim == Dimensions.NWAD) {
            diedIn.put(player.m_20148_(), (ResourceKey<Level>)dim);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID uuid = player.m_20148_();
        ResourceKey<Level> dim = diedIn.remove(uuid);
        if (dim == null || dim != Dimensions.NWAD) {
            return;
        }
        PlayerInvManager.restoreInv(player);
        player.m_143403_(GameType.SURVIVAL);
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(ResourceLocation.parse((String)"true_end:leave_the_nightmare_within_a_dream"));
        assert (advancement != null);
        AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
        if (!progress.m_8193_()) {
            for (String criteria : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criteria);
            }
        }
    }

    private static void teleportToNWAD(ServerPlayer player) {
        int y;
        if (player.m_9236_().m_46472_() == Dimensions.NWAD) {
            return;
        }
        ServerLevel next = player.f_8924_.m_129880_(Dimensions.NWAD);
        if (next == null) {
            return;
        }
        player.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, 0.0f));
        int x = player.m_146903_();
        int z = player.m_146907_();
        boolean found = false;
        for (y = 120; y > 0; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!next.m_46859_(pos) || !next.m_46859_(pos.m_7494_()) || next.m_46859_(pos.m_7495_())) continue;
            found = true;
            break;
        }
        if (!found) {
            y = 129;
        }
        player.m_8999_(next, (double)x, (double)(y + 1), (double)z, player.m_146908_(), player.m_146909_());
        player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
        player.m_21220_().forEach(e -> player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), e)));
    }
}

