/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures.advancement;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnARailTracker {
    private static final Map<UUID, BlockPos> startPositions = new HashMap<UUID, BlockPos>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_20202_() instanceof AbstractMinecart) {
            UUID playerId = player.m_20148_();
            BlockPos currentPos = player.m_20183_();
            if (!startPositions.containsKey(playerId)) {
                startPositions.put(playerId, currentPos);
            } else {
                BlockPos startPos = startPositions.get(playerId);
                int distance = Math.abs(currentPos.m_123341_() - startPos.m_123341_());
                if (distance >= 1000) {
                    OnARailTracker.grantAdvancement(player);
                    startPositions.remove(playerId);
                }
            }
        } else {
            startPositions.remove(player.m_20148_());
        }
    }

    private static void grantAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            AdvancementProgress progress;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ResourceLocation advancementId = ResourceLocation.parse((String)"true_end:story/travel_in_minecart");
            Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(advancementId);
            if (advancement != null && !(progress = serverPlayer.m_8960_().m_135996_(advancement)).m_8193_()) {
                for (String criterion : progress.m_8219_()) {
                    serverPlayer.m_8960_().m_135988_(advancement, criterion);
                }
            }
        }
    }
}

