/*
 * Decompiled with CFR 0.152.
 */
package net.mysticcreations.true_end.procedures.events;

import java.util.Locale;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mysticcreations.true_end.TrueEnd;
import net.mysticcreations.true_end.init.Dimensions;
import net.mysticcreations.true_end.network.Variables;
import net.mysticcreations.true_end.procedures.randomEvents.SoundPlayer;

@Mod.EventBusSubscriber
public class ChatReplies {
    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        ServerLevel world = event.getPlayer().m_284548_();
        ServerPlayer player = event.getPlayer();
        MinecraftServer server = player.m_20194_();
        if (server != null) {
            server.execute(() -> ChatReplies.lambda$onChat$0(event, (LevelAccessor)world, player));
        }
    }

    private static void sendChatReply(LevelAccessor world, String msg, Integer delay) {
        if (!world.m_5776_() && world.m_7654_() != null) {
            TrueEnd.wait(delay, () -> {
                MinecraftServer server = world.m_7654_();
                server.m_6846_().m_240416_((Component)Component.m_237113_((String)msg), false);
            });
        }
    }

    public static void hardcodedReplies(LevelAccessor world, String msg, ServerPlayer player) {
        int delay = (int)(Math.random() * 50.0 + 15.0);
        switch (msg) {
            case "sleep": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> No more.", delay);
                break;
            }
            case "awake": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> You.", delay);
                break;
            }
            case "where from": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> The fog.", delay);
                break;
            }
            case "why is it night": {
                ChatReplies.nightReply(player);
                break;
            }
            case "is anyone there": 
            case "anyone there": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> Yes.", delay);
                break;
            }
            case "who are you": 
            case "what is your name": 
            case "what's your name": 
            case "whats your name": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> Unknown. Forgotten.", delay);
                break;
            }
            case "nightmare": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> Within.", delay);
                break;
            }
            case "fuck you": {
                ChatReplies.punish(player);
                break;
            }
            case "where am i": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> " + (int)player.m_20185_() + "/" + (int)player.m_20186_() + "/" + (int)player.m_20189_() + ".", delay);
                break;
            }
            case "where are you": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> U29tZXdoZXJlIGNsb3NlLg==", delay);
                break;
            }
            case "hello": 
            case "hi": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> Hi.", delay);
                break;
            }
            case "go away": 
            case "please go away": 
            case "leave me alone": 
            case "can you leave me alone": 
            case "can you go away": 
            case "please leave me alone": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> I can't.", delay);
                break;
            }
            case "song": 
            case "sing": {
                ChatReplies.entitySings(world, delay, player);
                break;
            }
            case "i love you": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r>      ?      ", delay);
                break;
            }
            case "voices": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> Gods.", delay);
                break;
            }
            case "28/09/1939": 
            case "09/28/1939": {
                ChatReplies.meetAgain(player);
                break;
            }
            case "null": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> I'm not Null", delay);
                break;
            }
            case "the broken script": {
                ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> Inspiration.", delay);
                break;
            }
            case "zarsai": 
            case "zarsaivt": 
            case "shinhoa": 
            case "shinhoaz": 
            case "fireydude": 
            case "imfireydude": {
                ChatReplies.sendChatReply(world, "<SillyMili> <3", 30);
                break;
            }
            default: {
                ChatReplies.randomReplies(world, player);
            }
        }
    }

    public static void randomReplies(LevelAccessor world, ServerPlayer player) {
        if (player.m_9236_().m_46472_() == Dimensions.BTD) {
            return;
        }
        if (!(Math.random() < Variables.randomEventChance / 48.0)) {
            return;
        }
        int delay = 15 + (int)(Math.random() * 46.0);
        String[] messages = new String[]{"<\u00a7kUnknown\u00a7r> This isn't real.", "<\u00a7kUnknown\u00a7r> Wake up.", "<\u00a7kUnknown\u00a7r> " + player.m_7755_().getString().trim() + ".", "<\u00a7kUnknown\u00a7r> They see you.", "<\u00a7kUnknown\u00a7r> The world changes, but not them."};
        String chat = messages[new Random().nextInt(messages.length)];
        ChatReplies.sendChatReply(world, chat, delay);
    }

    private static void nightReply(ServerPlayer player) {
        boolean isDay;
        ServerLevel world = (ServerLevel)player.m_9236_();
        int delay = (int)(Math.random() * 50.0 + 15.0);
        long time = world.m_46467_() % 24000L;
        boolean bl = isDay = time >= 1000L && time < 13000L;
        if (!isDay) {
            ChatReplies.sendChatReply((LevelAccessor)world, "<\u00a7kUnknown\u00a7r> Sleep.", delay);
        } else {
            ChatReplies.sendChatReply((LevelAccessor)world, "<\u00a7kUnknown\u00a7r> It is not.", delay);
        }
    }

    private static void punish(ServerPlayer player) {
        int delay = (int)(Math.random() * 50.0 + 20.0);
        MinecraftServer server = player.f_8924_;
        String playerName = player.m_5446_().getString();
        String textA = "\u00a77\u00a7o[" + playerName + "'s game mode has been changed to Adventure Mode by \u00a7kUnknown\u00a7r\u00a77\u00a7o]";
        String textS = "\u00a77\u00a7o[" + playerName + "'s game mode has been changed to Survival Mode by \u00a7kUnknown\u00a7r\u00a77\u00a7o]";
        TrueEnd.wait(delay, () -> {
            player.m_143403_(GameType.ADVENTURE);
            server.m_6846_().m_240416_((Component)Component.m_237113_((String)textA), false);
            TrueEnd.wait(6000, () -> {
                player.m_143403_(GameType.SURVIVAL);
                server.m_6846_().m_240416_((Component)Component.m_237113_((String)textS), false);
            });
        });
    }

    private static void meetAgain(ServerPlayer player) {
        ServerLevel world = (ServerLevel)player.m_9236_();
        String[] lines = new String[]{"\u00a73We'll meet again", "\u00a72Don't know where", "\u00a73Don't know when", "\u00a72But I know we'll meet again", "Some sunny day", "\u00a73Keep smiling through", "\u00a72Just like you", "\u00a73always do", "\u00a72'Til the blue skies chase those dark clouds", "Far away"};
        int[] delays = new int[]{45, 40, 40, 40, 50, 55, 40, 40, 45, 50};
        int cumulative = 0;
        int i = 0;
        while (i < lines.length) {
            int idx = i++;
            TrueEnd.wait(cumulative += delays[i], () -> ChatReplies.sendChatReply((LevelAccessor)world, lines[idx], 0));
        }
    }

    private static void entitySings(LevelAccessor world, Integer delay, ServerPlayer player) {
        ChatReplies.sendChatReply(world, "<\u00a7kUnknown\u00a7r> 0100110101111001001000000110011001100001011101100110111101110010011010010111010001100101", delay);
        SoundPlayer.playSound(player, 10, "true_end:daisy_bell");
    }

    private static /* synthetic */ void lambda$onChat$0(ServerChatEvent event, LevelAccessor world, ServerPlayer player) {
        String msg = event.getMessage().getString().toLowerCase(Locale.ROOT).trim().replaceAll("[!?.-]+$", "");
        ChatReplies.hardcodedReplies(world, msg, player);
    }
}

