/*
 * Decompiled with CFR 0.152.
 */
package com.mod.windlaunch;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class WindLaunchPlugin
extends JavaPlugin
implements PluginMessageListener {
    public static final String CHANNEL = "windlaunch:handshake";
    private static final byte MSG_HELLO = 1;
    private static final byte MSG_OK = 2;
    private static final byte MSG_DENY = 3;

    public void onEnable() {
        this.getLogger().info("\ud83c\udf2c\ufe0f WindLaunchPlugin enabled, registering messaging channel");
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, CHANNEL, (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, CHANNEL);
    }

    public void onDisable() {
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this, CHANNEL);
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this, CHANNEL);
        this.getLogger().info("\ud83d\udd0c WindLaunchPlugin disabled");
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!CHANNEL.equals(channel)) {
            return;
        }
        try {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            byte code = in.readByte();
            this.getLogger().info("\u2194\ufe0f Handshake received from " + player.getName() + " (code=" + code + ")");
            byte response = 3;
            if (code == 1) {
                if (player.hasPermission("windlaunch.use")) {
                    response = 2;
                    this.getLogger().info("\u2705 Allowed WindLaunch for " + player.getName());
                } else {
                    response = 3;
                    this.getLogger().info("\u274c Denied WindLaunch for " + player.getName() + " (no permission)");
                }
            }
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeByte((int)response);
            player.sendPluginMessage((Plugin)this, CHANNEL, out.toByteArray());
            this.getLogger().info("\ud83d\udce4 Replied to " + player.getName() + " with code=" + response);
        }
        catch (Exception e) {
            this.getLogger().severe("\u26a0\ufe0f Handshake failed: " + e.getMessage());
        }
    }
}

