/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.plugins.backbone;

import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import tn.naizo.plugins.backbone.api.BackboneApi;
import tn.naizo.plugins.backbone.api.BackboneApiImpl;
import tn.naizo.plugins.backbone.license.LicenseManager;

public class Backbone
extends JavaPlugin {
    private LicenseManager licenseManager;

    public void onEnable() {
        this.getLogger().info("Backbone License Plugin starting up...");
        this.licenseManager = new LicenseManager(this);
        this.licenseManager.loadConfig();
        if (!this.licenseManager.verifyAllLicensesOnStartup()) {
            this.getLogger().severe("\u274c License verification failed! Disabling all plugins...");
            this.getServer().getPluginManager().disablePlugins();
            return;
        }
        this.registerApi();
        this.getLogger().info("\u2705 Backbone License Plugin enabled successfully!");
    }

    public void onDisable() {
        this.getLogger().info("Backbone License Plugin disabled.");
    }

    private void registerApi() {
        this.getServer().getServicesManager().register(BackboneApi.class, (Object)new BackboneApiImpl(this.licenseManager), (Plugin)this, ServicePriority.High);
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }
}

