/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.plugins.backbone.api;

import tn.naizo.plugins.backbone.api.BackboneApi;
import tn.naizo.plugins.backbone.license.LicenseManager;
import tn.naizo.plugins.backbone.license.VerificationConfig;

public class BackboneApiImpl
implements BackboneApi {
    private final LicenseManager licenseManager;

    public BackboneApiImpl(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    public boolean verify(String projectName, String licenseKey) {
        VerificationConfig config = this.licenseManager.getVerifications().get(projectName);
        if (config == null) {
            this.licenseManager.getPlugin().getLogger().warning("Project " + projectName + " is not configured.");
            return false;
        }
        if (licenseKey != null && !licenseKey.isEmpty()) {
            config.setLicenseKey(licenseKey);
        }
        return this.licenseManager.verifyLicense(projectName, config);
    }
}

