/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.plugins.backbone.license;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import tn.naizo.plugins.backbone.Backbone;
import tn.naizo.plugins.backbone.license.LicenseStatus;
import tn.naizo.plugins.backbone.license.VerificationConfig;
import tn.naizo.plugins.backbone.util.HwidUtil;

public class LicenseManager {
    private final Backbone a;
    private final Map<String, VerificationConfig> b = new HashMap<String, VerificationConfig>();
    private File c;
    private YamlConfiguration d;
    private static final String e_b64 = "aHR0cHM6Ly9hcGkubmlnaHRiZWFtLmNsb3VkL2FwaS9wdWJsaWMva2V5Lw==";
    private static final String K_VER_B64 = "dmVyaWZpY2F0aW9ucw==";
    private static final String K_LIC_B64 = "bGljZW5zZUtleQ==";
    private static final String K_STATUS_B64 = "c3RhdHVz";
    private static final String ACTIVE_B64 = "QUNUSVZF";
    private static final String DISABLED_B64 = "RElTQUJMVEVE";
    private static final String WARN_NO_VER_B64 = "wqfCrSBObyBsaWNlbnNlIHZlcmlmaWNhdGlvbnMgZm91bmQgSU4gY29uZmlnLnltZCE=";
    private static final String WARN_NO_CFG_B64 = "wqfCrSBObyBsaWNzZSBjb25maWd1cmF0aW9uIGZvdW5kIGZvciA=";
    private static final String INFO_VERIFY_B64 = "8J+RiCBWZXJpZnlpbmcgbGljZW5zZSBmb3Ig";
    private static final String AT_B64 = "ICBhdDog";
    private static final String RESP_B64 = "8J+QiCBMaWNlbnNlIHNlcnZlciByZXNwb25zZSAo";
    private static final String ERR_LIC_B64 = "4oCmIExpY2Vuc2UgZXJyb3IgZm9yIA==";
    private static final String MALFORMED_B64 = "4oCmIE1hbGZvcm1lZCBsaWNlbnNlIHJlc3BvbnNlIGZvciA=";
    private static final String MISMATCH_B64 = "8J+QqCBMaWNlbnNlIHByb2plY3QgbWlzYXRjaCEgRXhwZWN0ZWQ6IA==";
    private static final String EXPIRED_B64 = "4oCmIExpY2Vuc2UgZXhwaXJlZCBvbg==";
    private static final String INVALID_B64 = "4oCmIExpY2Vuc2UgaW52YWxpZCBvciBpbmFjdGl2ZSBmb3I=";
    private static final String CREATED_B64 = "4oCmIENyZWF0ZWQgbmV3IGxpY2Vuc2UgZW50cnkgZm9yICc=";
    private static final String FAILED_SAVE_B64 = "4oCmIEZhaWxlZCB0byBzYXZlIG5ldyBsaWNlbnNlIGVudHJ5IGZvciA=";

    public LicenseManager(Backbone plugin) {
        this.a = plugin;
    }

    private static String dec(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }

    public void loadConfig() {
        this.c = new File(this.a.getDataFolder(), "config.yml");
        if (!this.c.exists()) {
            this.a.saveDefaultConfig();
        }
        this.d = YamlConfiguration.loadConfiguration((File)this.c);
        String vk = LicenseManager.dec(K_VER_B64);
        if (this.d.contains(vk)) {
            for (String pname : this.d.getConfigurationSection(vk).getKeys(false)) {
                LicenseStatus st;
                String key = this.d.getString(vk + "." + pname + "." + LicenseManager.dec(K_LIC_B64));
                String status = this.d.getString(vk + "." + pname + "." + LicenseManager.dec(K_STATUS_B64), LicenseManager.dec(ACTIVE_B64));
                try {
                    st = LicenseStatus.valueOf(status);
                }
                catch (Exception ex) {
                    st = LicenseStatus.DISABLED;
                }
                this.b.put(pname, new VerificationConfig(key, st));
            }
        } else {
            this.a.getLogger().warning(LicenseManager.dec(WARN_NO_VER_B64));
        }
    }

    public boolean verifyAllLicensesOnStartup() {
        CompletableFuture[] arr = (CompletableFuture[])this.b.entrySet().stream().map(en -> CompletableFuture.supplyAsync(() -> this.verifyLicense((String)en.getKey(), (VerificationConfig)en.getValue()))).toArray(CompletableFuture[]::new);
        boolean all = true;
        for (int i = 0; i < arr.length; ++i) {
            try {
                boolean v = (Boolean)arr[i].get(10L, TimeUnit.SECONDS);
                if (v) continue;
                all = false;
                Object[] keys = this.b.keySet().toArray();
                String proj = keys.length > i ? String.valueOf(keys[i]) : "UNKNOWN";
                this.a.getLogger().severe("\u274c License verification failed for project: " + proj);
                continue;
            }
            catch (Exception ex) {
                this.a.getLogger().log(Level.SEVERE, "Error verifying license: " + ex.getMessage(), ex);
                all = false;
            }
        }
        return all;
    }

    public boolean verifyLicense(String projectName, VerificationConfig cfg) {
        if (cfg == null) {
            this.a.getLogger().warning(LicenseManager.dec(WARN_NO_CFG_B64) + projectName + ". Creating a new one...");
            cfg = new VerificationConfig("", LicenseStatus.DISABLED);
            this.b.put(projectName, cfg);
            this.saveNewLicenseEntry(projectName, cfg);
            return false;
        }
        if (cfg.getLicenseKey() == null || cfg.getLicenseKey().isEmpty()) {
            this.a.getLogger().warning("\u26a0 License key for " + projectName + " is missing!");
            return false;
        }
        try {
            String base = LicenseManager.dec(e_b64);
            String url = base + cfg.getLicenseKey();
            this.a.getLogger().info(LicenseManager.dec(INFO_VERIFY_B64) + "'" + projectName + "'" + LicenseManager.dec(AT_B64) + url);
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("X-Device-HWID", HwidUtil.getServerHWID(this.a));
            int rc = conn.getResponseCode();
            InputStream st = rc >= 200 && rc < 300 ? conn.getInputStream() : conn.getErrorStream();
            StringBuilder sb = new StringBuilder();
            if (st != null) {
                try (BufferedReader rdr = new BufferedReader(new InputStreamReader(st));){
                    String ln;
                    while ((ln = rdr.readLine()) != null) {
                        sb.append(ln);
                    }
                }
            }
            if (rc == 400) {
                try {
                    JsonObject err = JsonParser.parseString((String)sb.toString()).getAsJsonObject();
                    if (err.has("error")) {
                        String em = err.get("error").getAsString();
                        this.a.getLogger().severe(LicenseManager.dec(ERR_LIC_B64) + projectName + "': " + em);
                    } else {
                        this.a.getLogger().severe(LicenseManager.dec(ERR_LIC_B64) + projectName + "': Bad Request (400)");
                    }
                }
                catch (Exception ex) {
                    this.a.getLogger().severe("\u274c License server returned invalid JSON on error (400)");
                }
                cfg.setStatus(LicenseStatus.DISABLED);
                return false;
            }
            if (rc != 200) {
                this.a.getLogger().warning("\u26a0 License verification failed (HTTP " + rc + ") for '" + projectName + "'");
                cfg.setStatus(LicenseStatus.DISABLED);
                return false;
            }
            return this.parseAndValidateLicenseResponse(projectName, sb.toString(), cfg);
        }
        catch (Exception ex) {
            this.a.getLogger().log(Level.SEVERE, "\u2757 Failed to verify license for " + projectName + ": " + ex.getMessage(), ex);
            return false;
        }
    }

    private boolean parseAndValidateLicenseResponse(String projectName, String json, VerificationConfig cfg) {
        LicenseStatus parsed;
        String expiration;
        JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
        if (obj.has("error")) {
            String err = obj.get("error").getAsString();
            this.a.getLogger().warning("\u26a0 License check failed for '" + projectName + "': " + err);
            cfg.setStatus(LicenseStatus.DISABLED);
            return false;
        }
        if (!(obj.has("projectName") && obj.has("licenseKey") && obj.has("status"))) {
            this.a.getLogger().warning(LicenseManager.dec(MALFORMED_B64) + projectName + "'");
            cfg.setStatus(LicenseStatus.DISABLED);
            return false;
        }
        String apiName = obj.get("projectName").getAsString();
        String status = obj.get("status").getAsString().toUpperCase();
        String string = expiration = obj.has("expiresAt") ? obj.get("expiresAt").getAsString() : null;
        if (!apiName.equalsIgnoreCase(projectName)) {
            this.a.getLogger().severe(LicenseManager.dec(MISMATCH_B64) + projectName + " | Received: " + apiName);
            cfg.setStatus(LicenseStatus.DISABLED);
            return false;
        }
        try {
            parsed = LicenseStatus.valueOf(status);
        }
        catch (Exception ex) {
            parsed = LicenseStatus.DISABLED;
        }
        this.a.getLogger().info("\ud83d\udd0d License for '" + projectName + "' \u2192 Status: " + String.valueOf((Object)parsed) + (String)(expiration != null ? " | Expires At: " + expiration : ""));
        if (expiration != null && !expiration.equalsIgnoreCase("null")) {
            try {
                Date exp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(expiration);
                if (exp.before(new Date())) {
                    this.a.getLogger().warning(LicenseManager.dec(EXPIRED_B64) + expiration);
                    parsed = LicenseStatus.EXPIRED;
                }
            }
            catch (Exception ex) {
                this.a.getLogger().warning("\u26a0 Could not parse expiration date for '" + projectName + "'");
            }
        }
        if (parsed != LicenseStatus.ACTIVE) {
            this.a.getLogger().warning(LicenseManager.dec(INVALID_B64) + projectName + "'. Status: " + String.valueOf((Object)parsed));
        }
        cfg.setStatus(parsed);
        return parsed == LicenseStatus.ACTIVE;
    }

    private void saveNewLicenseEntry(String projectName, VerificationConfig cfg) {
        this.c = new File(this.a.getDataFolder(), "config.yml");
        String vk = LicenseManager.dec(K_VER_B64);
        this.d.set(vk + "." + projectName + "." + LicenseManager.dec(K_LIC_B64), (Object)cfg.getLicenseKey());
        try {
            this.d.save(this.c);
            this.a.getLogger().info(LicenseManager.dec(CREATED_B64) + projectName + "'.");
        }
        catch (IOException ex) {
            this.a.getLogger().log(Level.SEVERE, LicenseManager.dec(FAILED_SAVE_B64) + projectName + "'", ex);
        }
    }

    public Map<String, VerificationConfig> getVerifications() {
        return this.b;
    }

    public Backbone getPlugin() {
        return this.a;
    }
}

