/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.command;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.command.PartySlot;
import dev.cudzer.cobblemonsizevariation.config.ModConfig;
import dev.cudzer.cobblemonsizevariation.network.SizeChangedPacket;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ChangeSizeCommand {
    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pokesizer").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(src -> src.hasPermission(ModConfig.getPermission("cobblemonsizevariation.command.pokesizer")))).executes(ChangeSizeCommand::runResizeAll)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"member", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(ChangeSizeCommand.getPartyMemberNames((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).executes(ChangeSizeCommand::runRandomResizer)).then(Commands.argument((String)"size", (ArgumentType)DoubleArgumentType.doubleArg((double)CobblemonSizeVariation.SIZER.getMinSizeModifier(), (double)CobblemonSizeVariation.SIZER.getMaxSizeModifier())).executes(ChangeSizeCommand::runResizer))).then(Commands.literal((String)"check").executes(ChangeSizeCommand::checkSize))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"self").requires(src -> src.hasPermission(ModConfig.getPermission("cobblemonsizevariation.command.pokesizer.self")))).executes(ChangeSizeCommand::runResizeSelfAll)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"member", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(ChangeSizeCommand.getSelfPartyMemberNames((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).executes(ChangeSizeCommand::runRandomSelfResizer)).then(Commands.argument((String)"size", (ArgumentType)DoubleArgumentType.doubleArg((double)CobblemonSizeVariation.SIZER.getMinSizeModifier(), (double)CobblemonSizeVariation.SIZER.getMaxSizeModifier())).executes(ChangeSizeCommand::runSelfResizer))).then(Commands.literal((String)"check").executes(ChangeSizeCommand::checkSizeSelf)))));
    }

    private static int runResizeAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        PlayerPartyStore party = PlayerExtensionsKt.party((ServerPlayer)targetPlayer);
        if (party.size() != 0) {
            for (Pokemon targetPokemon : party.toGappyList()) {
                if (targetPokemon == null) continue;
                float sizeModifier = CobblemonSizeVariation.SIZER.getSize();
                targetPokemon.setScaleModifier(sizeModifier);
                CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(targetPlayer, (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> targetPokemon), Double.valueOf(sizeModifier)));
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("The size of %s's team has been randomized", targetPlayer.getName().getString())), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)String.format("%s doesn't have any Pokemon!", targetPlayer.getName().getString())));
        return -1;
    }

    private static int runResizeSelfAll(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getPlayer();
            if (targetPlayer == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You must be a player to run this command"));
                return -1;
            }
            PlayerPartyStore party = PlayerExtensionsKt.party((ServerPlayer)targetPlayer);
            if (party.size() != 0) {
                for (Pokemon targetPokemon : party.toGappyList()) {
                    if (targetPokemon == null) continue;
                    float sizeModifier = CobblemonSizeVariation.SIZER.getSize();
                    targetPokemon.setScaleModifier(sizeModifier);
                    CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(targetPlayer, (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> targetPokemon), Double.valueOf(sizeModifier)));
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"The size of your team has been randomized"), true);
                return 0;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You don't have any Pokemon!"));
            return -1;
        }
        return -1;
    }

    private static int runResizer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        String partyMember = StringArgumentType.getString(context, (String)"member");
        double sizeModifier = DoubleArgumentType.getDouble(context, (String)"size");
        return ChangeSizeCommand.resize(context, targetPlayer, partyMember, (float)sizeModifier, false);
    }

    private static int runRandomResizer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        String partyMember = StringArgumentType.getString(context, (String)"member");
        return ChangeSizeCommand.resize(context, targetPlayer, partyMember, CobblemonSizeVariation.SIZER.getSize(), false);
    }

    private static int runRandomSelfResizer(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getPlayer();
            if (targetPlayer == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You must be a player to run this command"));
                return -1;
            }
            String partyMember = StringArgumentType.getString(context, (String)"member");
            return ChangeSizeCommand.resize(context, targetPlayer, partyMember, CobblemonSizeVariation.SIZER.getSize(), true);
        }
        return -1;
    }

    private static int runSelfResizer(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getPlayer();
            if (targetPlayer == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You must be a player to run this command"));
                return -1;
            }
            String partyMember = StringArgumentType.getString(context, (String)"member");
            double sizeModifier = DoubleArgumentType.getDouble(context, (String)"size");
            return ChangeSizeCommand.resize(context, targetPlayer, partyMember, (float)sizeModifier, true);
        }
        return -1;
    }

    private static int checkSize(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        String partyMember = StringArgumentType.getString(context, (String)"member");
        return ChangeSizeCommand.getSize(context, targetPlayer, partyMember, false);
    }

    private static int checkSizeSelf(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getPlayer();
            if (targetPlayer == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"You must be a player to run this command"));
                return -1;
            }
            String partyMember = StringArgumentType.getString(context, (String)"member");
            return ChangeSizeCommand.getSize(context, targetPlayer, partyMember, true);
        }
        return -1;
    }

    private static int resize(CommandContext<CommandSourceStack> context, ServerPlayer player, String pokemon, float size, boolean isSelf) {
        String failure;
        String success;
        PlayerPartyStore party = PlayerExtensionsKt.party((ServerPlayer)player);
        Pokemon targetPokemon = null;
        if (ChangeSizeCommand.getPartySlots().contains(pokemon)) {
            int slot = PartySlot.valueOf(pokemon).getSlot();
            targetPokemon = party.get(slot);
            success = isSelf ? String.format("The size of your pokemon in %s was changed!", PartySlot.valueOf(pokemon).getDisplayText()) : String.format("The size of %s's pokemon in %s was changed!", player.getName().getString(), PartySlot.valueOf(pokemon).getDisplayText());
            failure = isSelf ? String.format("You have a have a pokemon in %s", PartySlot.valueOf(pokemon).getDisplayText()) : String.format("%s doesn't have a pokemon in %s", player.getName().getString(), PartySlot.valueOf(pokemon).getDisplayText());
        } else {
            for (Pokemon pok : party.toGappyList()) {
                if (pok == null || !pok.getSpecies().getName().equalsIgnoreCase(pokemon)) continue;
                targetPokemon = pok;
            }
            if (targetPokemon != null) {
                success = isSelf ? String.format("The size of your %s was changed!", targetPokemon.getSpecies().getName()) : String.format("The size of %s's %s was changed!", player.getName().getString(), targetPokemon.getSpecies().getName());
                failure = "";
            } else {
                success = "";
                String string = failure = isSelf ? String.format("You have a have a %s", pokemon) : String.format("%s doesn't have a %s", player.getName().getString(), pokemon);
            }
        }
        if (targetPokemon != null) {
            if (ChangeSizeCommand.getPartySlots().contains(pokemon)) {
                targetPokemon.setScaleModifier(size);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)success), true);
                Pokemon finalTargetPokemon = targetPokemon;
                CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(player, (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> finalTargetPokemon), Double.valueOf(size)));
                return 0;
            }
            targetPokemon.setScaleModifier(size);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)success), true);
            Pokemon finalTargetPokemon1 = targetPokemon;
            CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(player, (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> finalTargetPokemon1), Double.valueOf(size)));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)failure));
        return -1;
    }

    private static int getSize(CommandContext<CommandSourceStack> context, ServerPlayer player, String pokemon, boolean isSelf) {
        String failure;
        String success;
        PlayerPartyStore party = PlayerExtensionsKt.party((ServerPlayer)player);
        Pokemon targetPokemon = null;
        if (ChangeSizeCommand.getPartySlots().contains(pokemon)) {
            int slot = PartySlot.valueOf(pokemon).getSlot();
            targetPokemon = party.get(slot);
            if (targetPokemon != null) {
                float pokemonSize = targetPokemon.getScaleModifier();
                success = isSelf ? String.format("The size of your pokemon in %s is %.2f", PartySlot.valueOf(pokemon).getDisplayText(), Float.valueOf(pokemonSize)) : String.format("The size of %s's pokemon in %s is %.2f!", player.getName().getString(), PartySlot.valueOf(pokemon).getDisplayText(), Float.valueOf(pokemonSize));
                failure = isSelf ? String.format("You have a have a pokemon in %s", PartySlot.valueOf(pokemon).getDisplayText()) : String.format("%s doesn't have a pokemon in %s", player.getName().getString(), PartySlot.valueOf(pokemon).getDisplayText());
            } else {
                success = "";
                failure = isSelf ? String.format("You have a have a pokemon in %s", pokemon) : String.format("%s doesn't have a pokemon in %s", player.getName().getString(), pokemon);
            }
        } else {
            for (Pokemon pok : party.toGappyList()) {
                if (pok == null || !pok.getSpecies().getName().equalsIgnoreCase(pokemon)) continue;
                targetPokemon = pok;
            }
            if (targetPokemon != null) {
                float pokemonSize = targetPokemon.getScaleModifier();
                success = isSelf ? String.format("The size of your %s is %.2f", targetPokemon.getSpecies().getName(), Float.valueOf(pokemonSize)) : String.format("The size of %s's %s is %.2f", player.getName().getString(), targetPokemon.getSpecies().getName(), Float.valueOf(pokemonSize));
                failure = "";
            } else {
                success = "";
                String string = failure = isSelf ? String.format("You have a have a %s", pokemon) : String.format("%s doesn't have a %s", player.getName().getString(), pokemon);
            }
        }
        if (targetPokemon != null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)success), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)failure));
        return -1;
    }

    private static Set<String> getPartyMemberNames(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
        PlayerPartyStore party = PlayerExtensionsKt.party((ServerPlayer)targetPlayer);
        HashSet<String> partyMembers = new HashSet<String>();
        party.toGappyList().stream().filter(Objects::nonNull).map(p -> p.getSpecies().getName()).forEach(partyMembers::add);
        partyMembers.addAll(ChangeSizeCommand.getPartySlots());
        return partyMembers;
    }

    private static Set<String> getSelfPartyMemberNames(CommandContext<CommandSourceStack> context) {
        ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getPlayer();
        if (targetPlayer != null) {
            PlayerPartyStore party = PlayerExtensionsKt.party((ServerPlayer)targetPlayer);
            HashSet<String> partyMembers = new HashSet<String>();
            party.toGappyList().stream().filter(Objects::nonNull).map(p -> p.getSpecies().getName()).forEach(partyMembers::add);
            partyMembers.addAll(ChangeSizeCommand.getPartySlots());
            return partyMembers;
        }
        return new HashSet<String>();
    }

    private static Set<String> getPartySlots() {
        HashSet<String> slots = new HashSet<String>();
        for (PartySlot partySlot : PartySlot.values()) {
            slots.add(partySlot.toString());
        }
        return slots;
    }
}

