/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.data;

import com.cobblemon.mod.common.pokemon.Species;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class PokemonSize {
    public static Codec<PokemonSize> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.listOf().fieldOf("species").forGetter(t -> t.speciesList), (App)Codec.FLOAT.fieldOf("minSize").forGetter(t -> Float.valueOf(t.minSize)), (App)Codec.FLOAT.fieldOf("maxSize").forGetter(t -> Float.valueOf(t.maxSize))).apply((Applicative)inst, PokemonSize::new));
    protected final List<String> speciesList;
    protected final float minSize;
    protected final float maxSize;
    private ResourceLocation jsonLocation;

    public PokemonSize(List<String> speciesList, float minSize, float maxSize) {
        this.speciesList = speciesList;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public float getMinSize() {
        return this.minSize;
    }

    public float getMaxSize() {
        return this.maxSize;
    }

    public void setJsonLocation(ResourceLocation jsonLocation) {
        this.jsonLocation = jsonLocation;
    }

    public boolean isPokemonIncluded(Species species) {
        return this.speciesList.contains(species.getName().toLowerCase());
    }
}

