/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.events.pokemon.ShoulderMountEvent;
import com.cobblemon.mod.common.api.events.starter.StarterChosenEvent;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.config.ModConfig;
import dev.cudzer.cobblemonsizevariation.data.CustomSizeDataManager;
import dev.cudzer.cobblemonsizevariation.data.PokemonSize;
import dev.cudzer.cobblemonsizevariation.network.SizeChangedPacket;
import java.util.Objects;
import java.util.Random;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class ModEvents {
    private static final Random random = new Random();

    public static void registerEvents() {
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.NORMAL, ModEvents::onCobblemonSpawn);
        CobblemonEvents.SHOULDER_MOUNT.subscribe(Priority.NORMAL, ModEvents::onShoulderMount);
        CobblemonEvents.STARTER_CHOSEN.subscribe(Priority.NORMAL, ModEvents::onStarterChosen);
        CobblemonEvents.FOSSIL_REVIVED.subscribe(Priority.NORMAL, ModEvents::onFossilRevived);
    }

    private static Unit onCobblemonSpawn(SpawnEvent<PokemonEntity> event) {
        return ModEvents.resizer(((PokemonEntity)event.getEntity()).getPokemon(), null, false);
    }

    private static Unit onShoulderMount(ShoulderMountEvent event) {
        Pokemon p = event.getPokemon();
        if (p.getScaleModifier() > ModConfig.preventShoulderMountSize) {
            MutableComponent tooHeavyMessage = Component.literal((String)"This Cobblemon is too chonky to sit on your shoulder!");
            event.getPlayer().sendSystemMessage((Component)tooHeavyMessage);
            event.cancel();
        }
        return Unit.INSTANCE;
    }

    private static Unit onStarterChosen(StarterChosenEvent event) {
        return ModEvents.resizer(event.getPokemon(), event.getPlayer(), false);
    }

    private static Unit onFossilRevived(FossilRevivedEvent event) {
        return ModEvents.resizer(event.getPokemon(), event.getPlayer(), true);
    }

    private static boolean canModifySize() {
        return random.nextFloat() < ModConfig.sizeModificationChance;
    }

    private static Unit resizer(Pokemon pokemon, ServerPlayer player, boolean requireClientUpdate) {
        if (ModEvents.canModifySize()) {
            double sizeModifier;
            PokemonSize customSize = CustomSizeDataManager.getCustomSizeFile(pokemon.getSpecies());
            if (customSize == null) {
                sizeModifier = CobblemonSizeVariation.SIZER.getSize();
                pokemon.setScaleModifier((float)sizeModifier);
            } else {
                sizeModifier = CobblemonSizeVariation.SIZER.getSize(customSize.getMinSize(), customSize.getMaxSize());
                pokemon.setScaleModifier((float)sizeModifier);
            }
            if (requireClientUpdate) {
                CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(Objects.requireNonNull(player), (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> pokemon), sizeModifier));
            }
        }
        return Unit.INSTANCE;
    }
}

