/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.neoforge;

import com.cobblemon.mod.common.NetworkManager;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.neoforge.net.NeoForgePacketInfo;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.network.ModNetwork;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="cobblemonsizevariation")
public class ModNeoForgeNetworkManager
implements NetworkManager {
    private static final String PROTOCOL_VERSION = "1.0";

    @SubscribeEvent
    public static void registerMessages(RegisterPayloadHandlersEvent event) {
        CobblemonSizeVariation.LOGGER.info("Registering packets for Cobblemon Size Variations");
        PayloadRegistrar registrar = event.registrar("cobblemonsizevariation").versioned(PROTOCOL_VERSION);
        ModNetwork.s2cPayloads.stream().map(NeoForgePacketInfo::new).forEach(np -> np.registerToClient(registrar));
    }

    public void sendPacketToPlayer(@NotNull ServerPlayer serverPlayer, @NotNull NetworkPacket<?> networkPacket) {
        serverPlayer.connection.send(networkPacket);
    }

    public void sendToServer(@NotNull NetworkPacket<?> networkPacket) {
        Objects.requireNonNull(Minecraft.getInstance().getConnection()).send(networkPacket);
    }
}

