/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.sizing.algorithms;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.config.ModConfig;
import dev.cudzer.cobblemonsizevariation.config.Size;
import dev.cudzer.cobblemonsizevariation.sizing.SizeDefinition;
import dev.cudzer.cobblemonsizevariation.sizing.algorithms.ISizer;
import dev.cudzer.cobblemonsizevariation.utils.FileUtils;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Random;

public class BasicSizer
implements ISizer {
    private static final Random RNG = new Random();
    private final SizeDefinition sizeDefinition;
    private final float minSizeModifier;
    private final float maxSizeModifier;

    public BasicSizer(SizeDefinition sizeDefinition) {
        this.sizeDefinition = sizeDefinition;
        this.minSizeModifier = Float.parseFloat(this.sizeDefinition.getMinSizeModifier());
        this.maxSizeModifier = Float.parseFloat(this.sizeDefinition.getMaxSizeModifier());
    }

    @Override
    public float getSize() {
        float result = 0.0f;
        if (ModConfig.biasSizeTowardAverage) {
            for (int i = 0; i < 3; ++i) {
                result += RNG.nextFloat() * ((this.maxSizeModifier - this.minSizeModifier + this.minSizeModifier) / 3.0f);
            }
        } else {
            result = RNG.nextFloat() * (this.maxSizeModifier - this.minSizeModifier) + this.minSizeModifier;
        }
        return result;
    }

    @Override
    public float getSize(float min, float max) {
        float result = 0.0f;
        if (ModConfig.biasSizeTowardAverage) {
            for (int i = 0; i < 3; ++i) {
                result += RNG.nextFloat() * ((max - min + min) / 3.0f);
            }
        } else {
            result = RNG.nextFloat() * (max - min) + min;
        }
        return result;
    }

    @Override
    public Size getSizeInformation(float size) {
        List<Size> sizeDefinitions = this.sizeDefinition.getSizes();
        if (size > this.maxSizeModifier) {
            return sizeDefinitions.getLast();
        }
        if (size < this.minSizeModifier) {
            return sizeDefinitions.getFirst();
        }
        for (Size s : sizeDefinitions) {
            if (!(size >= Float.parseFloat(s.min())) || !(size <= Float.parseFloat(s.max()))) continue;
            return s;
        }
        return null;
    }

    @Override
    public float getMinSizeModifier() {
        return this.minSizeModifier;
    }

    @Override
    public float getMaxSizeModifier() {
        return this.maxSizeModifier;
    }

    public static JsonElement createConfig(Path sizeFile) {
        JsonObject configuration;
        JsonObject defaultConfiguration = new JsonObject();
        BasicSizer.addDefaultFields(defaultConfiguration);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            configuration = JsonParser.parseReader((Reader)new FileReader(sizeFile.toString())).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            configuration = FileUtils.createFile(gson, defaultConfiguration, sizeFile);
        }
        if (configuration != null) {
            return configuration;
        }
        CobblemonSizeVariation.LOGGER.error("File for basic sizer was not created.");
        throw new RuntimeException("The configured size algorithm was not loaded correctly");
    }

    private static void addDefaultFields(JsonObject defaultConfig) {
        defaultConfig.addProperty("name", "basic");
        defaultConfig.addProperty("minSizeModifier", "0.2");
        defaultConfig.addProperty("maxSizeModifier", "2.0");
        defaultConfig.add("sizes", (JsonElement)BasicSizer.generateDefaultSizeDefinitions());
    }

    private static JsonArray generateDefaultSizeDefinitions() {
        JsonArray sizeDefinitions = new JsonArray();
        JsonObject tinyDefinition = new JsonObject();
        tinyDefinition.addProperty("name", "Tiny");
        tinyDefinition.addProperty("min", "0.2");
        tinyDefinition.addProperty("max", "0.5");
        tinyDefinition.addProperty("color", "#1b88cc");
        sizeDefinitions.add((JsonElement)tinyDefinition);
        JsonObject smallDefinition = new JsonObject();
        smallDefinition.addProperty("name", "Small");
        smallDefinition.addProperty("min", "0.51");
        smallDefinition.addProperty("max", "0.9");
        smallDefinition.addProperty("color", "#1bcc9a");
        sizeDefinitions.add((JsonElement)smallDefinition);
        JsonObject averageDefinition = new JsonObject();
        averageDefinition.addProperty("name", "Average");
        averageDefinition.addProperty("min", "0.91");
        averageDefinition.addProperty("max", "1.2");
        averageDefinition.addProperty("color", "#ffffff");
        sizeDefinitions.add((JsonElement)averageDefinition);
        JsonObject bigDefinition = new JsonObject();
        bigDefinition.addProperty("name", "Big");
        bigDefinition.addProperty("min", "1.21");
        bigDefinition.addProperty("max", "1.6");
        bigDefinition.addProperty("color", "#e6ff2b");
        sizeDefinitions.add((JsonElement)bigDefinition);
        JsonObject largeDefinition = new JsonObject();
        largeDefinition.addProperty("name", "Large");
        largeDefinition.addProperty("min", "1.61");
        largeDefinition.addProperty("max", "1.9");
        largeDefinition.addProperty("color", "#f07426");
        sizeDefinitions.add((JsonElement)largeDefinition);
        JsonObject hugeDefinition = new JsonObject();
        hugeDefinition.addProperty("name", "Huge");
        hugeDefinition.addProperty("min", "1.91");
        hugeDefinition.addProperty("max", "2.0");
        hugeDefinition.addProperty("color", "#f21800");
        sizeDefinitions.add((JsonElement)hugeDefinition);
        return sizeDefinitions;
    }
}

